/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.IBuiltinFunctions;
import com.schemarise.alfa.runtime.ILogger;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.Logger;
import com.schemarise.alfa.runtime.MessagingSupport;
import com.schemarise.alfa.runtime.PersistenceSupport;
import com.schemarise.alfa.runtime.RuntimeContext;
import com.schemarise.alfa.runtime_int.DefaultMessagingSupport;
import com.schemarise.alfa.runtime_int.DefaultPersistenceSupport;
import com.schemarise.alfa.runtime_int.IntImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

class DefaultRuntimeContext
implements RuntimeContext {
    private static String ALGORITHM = "RSA";
    private final IBuiltinFunctions builtins;
    private final PersistenceSupport persistenceSupport;
    private final MessagingSupport messagingSupport;
    private Cipher publicKeyCipher;
    private Cipher privateKeyCipher;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private ILogger logger = Logger.getOrCreateDefault();
    private static DefaultRuntimeContext self = new DefaultRuntimeContext(new DefaultPersistenceSupport(), new DefaultMessagingSupport());

    public DefaultRuntimeContext(PersistenceSupport ps, MessagingSupport ms) {
        this.setupKeyPair();
        this.builtins = IntImpl.createBuiltinFunctions(this);
        this.persistenceSupport = ps;
        this.messagingSupport = ms;
    }

    public static DefaultRuntimeContext getInstance() {
        return self;
    }

    private byte[] readStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public void logKeyInfo() throws Exception {
        this._logKeyInfo("Private", this.privateKey);
    }

    private void _logKeyInfo(String type, RSAKey key) throws Exception {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPrivateCrtKeySpec ks = kf.getKeySpec(this.privateKey, RSAPrivateCrtKeySpec.class);
        StringBuffer sb = new StringBuffer();
        sb.append("<RSAKeyValue>\n");
        sb.append("    <Modulus>" + String.valueOf(ks.getModulus()) + "</Modulus>\n");
        sb.append("    <Exponent>" + String.valueOf(ks.getPublicExponent()) + "</Exponent>\n");
        sb.append("    <P>" + String.valueOf(ks.getPrimeP()) + "</P>\n");
        sb.append("    <Q>" + String.valueOf(ks.getPrimeQ()) + "</Q>\n");
        sb.append("    <DP>" + String.valueOf(ks.getPrimeExponentP()) + "</DP>\n");
        sb.append("    <DQ>" + String.valueOf(ks.getPrimeExponentQ()) + "</DQ>\n");
        sb.append("    <InverseQ>" + String.valueOf(ks.getCrtCoefficient()) + "</InverseQ>\n");
        sb.append("    <D>" + String.valueOf(ks.getPrivateExponent()) + "</D>\n");
        sb.append("</RSAKeyValue>");
        DefaultRuntimeContext.binToString("Modulus", ks.getModulus());
        DefaultRuntimeContext.binToString("Exponent", ks.getPublicExponent());
        DefaultRuntimeContext.binToString("P", ks.getPrimeP());
        DefaultRuntimeContext.binToString("Q", ks.getPrimeQ());
        DefaultRuntimeContext.binToString("DP", ks.getPrimeExponentP());
        DefaultRuntimeContext.binToString("DQ", ks.getPrimeExponentQ());
        DefaultRuntimeContext.binToString("InverseQ", ks.getCrtCoefficient());
        DefaultRuntimeContext.binToString("D", ks.getPrivateExponent());
        System.out.println(sb.toString());
    }

    private static void binToString(String type, BigInteger a) {
        byte[] b = a.toByteArray();
        b = DefaultRuntimeContext.stripLeadingZeros(b);
        String modulusB64 = Base64.getEncoder().encodeToString(b);
        System.out.println("private static string " + type + " = \"" + modulusB64 + "\";");
    }

    private static byte[] stripLeadingZeros(byte[] a) {
        int lastZero = -1;
        int i = 0;
        while (i < a.length && a[i] == 0) {
            lastZero = i++;
        }
        byte[] result = new byte[a.length - ++lastZero];
        System.arraycopy(a, lastZero, result, 0, result.length);
        return result;
    }

    private void setupKeyPair() {
        try {
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            InputStream is = DefaultRuntimeContext.class.getClassLoader().getResource("alfa-sample-pke-keys/sample_private_key.der").openStream();
            byte[] keyBytes = this.readStream(is);
            PKCS8EncodedKeySpec specPrivate = new PKCS8EncodedKeySpec(keyBytes);
            this.privateKey = (RSAPrivateKey)kf.generatePrivate(specPrivate);
            is.close();
            is = DefaultRuntimeContext.class.getClassLoader().getResource("alfa-sample-pke-keys/sample_public_key.der").openStream();
            keyBytes = this.readStream(is);
            X509EncodedKeySpec specPublic = new X509EncodedKeySpec(keyBytes);
            this.publicKey = (RSAPublicKey)kf.generatePublic(specPublic);
            is.close();
            this.publicKeyCipher = Cipher.getInstance(ALGORITHM);
            this.publicKeyCipher.init(1, this.publicKey);
            this.privateKeyCipher = Cipher.getInstance(ALGORITHM);
            this.privateKeyCipher.init(2, this.privateKey);
        }
        catch (Throwable e) {
            throw new AlfaRuntimeException(ConstraintType.Unknown, "Failed to process keys", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] inputData) {
        try {
            byte[] encryptedBytes = this.publicKeyCipher.doFinal(inputData);
            return encryptedBytes;
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(byte[] inputData) {
        try {
            byte[] decryptedBytes = this.privateKeyCipher.doFinal(inputData);
            return decryptedBytes;
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public byte[] compress(byte[] data) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = new GZIPOutputStream(out);
            gzipStream.write(data, 0, data.length);
            gzipStream.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public byte[] uncompress(byte[] data) {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] buffer = new byte[1024];
            while ((len = gzipStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            gzipStream.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public IBuiltinFunctions getBuiltinFunctions() {
        return this.builtins;
    }

    @Override
    public <T extends AlfaObject> List<T> query(Optional<AlfaObject> currentObject, String entityName, Expression.CaseLambdaExpr condition, Map<String, Integer> sort, int limit, Optional<String> storeName) {
        return this.persistenceSupport.query(currentObject, entityName, condition, sort, limit, Optional.empty());
    }

    @Override
    public <T extends AlfaObject> Optional<T> lookup(String entityName, Key ok, Optional<String> storeName) {
        return this.persistenceSupport.lookup(entityName, ok, Optional.empty());
    }

    @Override
    public <T extends Entity> void save(T entity, Optional<String> storeName) {
        this.persistenceSupport.save(entity, Optional.empty());
    }

    @Override
    public <T extends AlfaObject> void publish(String queueName, T alfaObj) {
        this.messagingSupport.publish(queueName, alfaObj);
    }

    @Override
    public <T extends AlfaObject> Boolean keyExists(String entityName, Key ok, Optional<String> storeName) {
        return this.persistenceSupport.keyExists(entityName, ok, Optional.empty());
    }

    @Override
    public <T extends AlfaObject> boolean exists(String entityName, Expression.CaseLambdaExpr condition, Optional<String> storeName) {
        return this.persistenceSupport.exists(entityName, condition, Optional.empty());
    }
}

