/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.EntityBuilder;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.Logger;
import com.schemarise.alfa.runtime.NoOpDataSupplier;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Record;
import com.schemarise.alfa.runtime.TypeChecksum;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.UntaggedUnionBuilder;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.json.IJsonParserWrapper;
import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import com.schemarise.alfa.runtime.utils.MRUHashMap;
import com.schemarise.alfa.runtime.utils.Utils;
import com.schemarise.alfa.runtime_int.IntImpl;
import com.schemarise.alfa.runtime_int.JsonDataConsumer;
import com.schemarise.alfa.runtime_int.JsonParserWrapper;
import java.math.BigDecimal;
import java.net.URI;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.EnumDataType;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.MetaDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.PairDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.TupleDataType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;
import schemarise.alfa.runtime.model.UnionDataType;
import schemarise.alfa.runtime.model.UnionType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;

final class JsonDataSupplier
extends DataSupplier {
    private final JsonCodecConfig jsonCfg;
    private Map<String, DateTimeFormatter> datetimeFormatMap = new HashMap<String, DateTimeFormatter>();
    private final IJsonParserWrapper parser;
    private static final Map<String, LocalDate> localDates = new WeakHashMap<String, LocalDate>();
    private static final String NoType = "Did not see $type field";
    private static Map<String, LocalDateTime> datetimesCache = new MRUHashMap<String, LocalDateTime>(1000);
    private static Map<String, ZonedDateTime> datetimetzsCache = new MRUHashMap<String, ZonedDateTime>(1000);

    public JsonDataSupplier(JsonCodecConfig jwc, JsonParser parser) {
        super(jwc);
        this.jsonCfg = jwc;
        this.parser = new JsonParserWrapper(parser);
    }

    @Override
    public int intValue(ScalarDataType scalarDataType) {
        int i = this.parser.currentToken() != JsonToken.VALUE_NUMBER_INT ? Integer.valueOf(this.getSafeText()).intValue() : this.parser.getIntValue();
        return i;
    }

    @Override
    public String stringValue(ScalarDataType scalarDataType) {
        return this.getSafeText();
    }

    @Override
    protected JsonCodecConfig getCodecConfig() {
        return (JsonCodecConfig)super.getCodecConfig();
    }

    @Override
    public double doubleValue(ScalarDataType scalarDataType) {
        if (this.parser.currentToken() != JsonToken.VALUE_NUMBER_FLOAT) {
            return Double.valueOf(this.getSafeText());
        }
        return this.parser.getDoubleValue();
    }

    @Override
    public short shortValue(ScalarDataType scalarDataType) {
        if (this.parser.currentToken() != JsonToken.VALUE_NUMBER_INT) {
            return Short.valueOf(this.getSafeText());
        }
        return this.parser.getShortValue();
    }

    @Override
    public long longValue(ScalarDataType scalarDataType) {
        if (this.parser.currentToken() != JsonToken.VALUE_NUMBER_INT) {
            return Long.valueOf(this.getSafeText());
        }
        return this.parser.getLongValue();
    }

    @Override
    public byte byteValue(ScalarDataType scalarDataType) {
        return this.parser.getByteValue();
    }

    @Override
    public char charValue(ScalarDataType scalarDataType) {
        return this.parser.getTextCharacters()[0];
    }

    @Override
    public boolean booleanValue(ScalarDataType scalarDataType) {
        JsonToken t = this.parser.currentToken();
        if (t != JsonToken.VALUE_FALSE && t != JsonToken.VALUE_TRUE) {
            return Boolean.valueOf(this.getSafeText());
        }
        return this.parser.getBooleanValue();
    }

    @Override
    public BigDecimal decimalValue(ScalarDataType scalarDataType) {
        return this.parser.getBigDecimalValue();
    }

    @Override
    public LocalDate dateValue(ScalarDataType t) {
        return this.cachedDateValue(t, this.getSafeText());
    }

    @Override
    public LocalDateTime datetimeValue(ScalarDataType dt) {
        LocalDateTime sdt;
        String t = this.getSafeText();
        String v = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        try {
            if (dt.getStrPattern().isPresent() && !this.getCodecConfig().isIgnoreDateFormat()) {
                v = dt.getStrPattern().get();
                DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
                sdt = this.datetimeValue(dt, t, df, v);
            } else {
                sdt = this.datetimeValue(dt, t, DateTimeFormatter.ISO_DATE_TIME, v);
            }
        }
        catch (DateTimeException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, "Failed expected format '" + v + "' for datetime value '" + t + "'", e);
        }
        return sdt;
    }

    @Override
    public ZonedDateTime datetimetzValue(ScalarDataType dt) {
        ZonedDateTime sdt;
        String t = this.getSafeText();
        String v = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        try {
            if (dt.getStrPattern().isPresent()) {
                v = dt.getStrPattern().get();
                DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
                sdt = this.datetimetzValue(dt, t, df, v);
            } else {
                sdt = this.datetimetzValue(dt, t, DateTimeFormatter.ISO_DATE_TIME, v);
            }
        }
        catch (DateTimeException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, "Failed expected format '" + v + "' for datetimetz value '" + t + "'", e);
        }
        return sdt;
    }

    private LocalDateTime datetimeValue(ScalarDataType dt, String dateVal, DateTimeFormatter dtFmt, String fmtStr) {
        String k = dateVal + "|" + fmtStr;
        LocalDateTime ldt = datetimesCache.get(k);
        if (ldt != null) {
            return ldt;
        }
        ldt = LocalDateTime.parse(dateVal, dtFmt);
        datetimesCache.put(k, ldt);
        return ldt;
    }

    private ZonedDateTime datetimetzValue(ScalarDataType dt, String dateVal, DateTimeFormatter dtFmt, String fmtStr) {
        String k = dateVal + "|" + fmtStr;
        ZonedDateTime ldt = datetimetzsCache.get(k);
        if (ldt != null) {
            return ldt;
        }
        ldt = ZonedDateTime.parse(dateVal, dtFmt);
        datetimetzsCache.put(k, ldt);
        return ldt;
    }

    @Override
    public LocalTime timeValue(ScalarDataType scalarDataType) {
        String t = this.getSafeText();
        try {
            return LocalTime.parse(t, DateTimeFormatter.ISO_TIME);
        }
        catch (DateTimeException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, "Failed expected format 'HH:mm[:ss.SSS]' for time value '" + String.valueOf(e) + "'", e);
        }
    }

    @Override
    public float floatValue(ScalarDataType scalarDataType) {
        if (this.parser.currentToken() != JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(this.getSafeText()).floatValue();
        }
        double d = this.parser.getDoubleValue();
        if (d > 3.4028234663852886E38) {
            throw new NumberFormatException();
        }
        return (float)d;
    }

    @Override
    public byte[] binaryValue(ScalarDataType scalarDataType) {
        return this.parser.getBinaryValue();
    }

    @Override
    public Duration durationValue(ScalarDataType scalarDataType) {
        return Duration.parse(this.getSafeText());
    }

    @Override
    public NormalizedPeriod periodValue(ScalarDataType scalarDataType) {
        return NormalizedPeriod.of(this.getSafeText());
    }

    @Override
    public UUID uuidValue(ScalarDataType scalarDataType) {
        String t = this.getSafeText();
        return UUID.fromString(t);
    }

    @Override
    public URI uriValue(ScalarDataType scalarDataType) {
        String t = this.getSafeText();
        return URI.create(t);
    }

    @Override
    public <T> Optional<T> optionalValue(OptionalDataType f, Function<DataSupplier, T> c) {
        if (this.parser.currentToken() == JsonToken.VALUE_NULL) {
            return Optional.empty();
        }
        T r = c.apply(this);
        Optional<T> v = Optional.ofNullable(r);
        return v;
    }

    @Override
    public String patternValue(ScalarDataType scalarDataType) {
        String pat = this.getSafeText();
        return pat;
    }

    @Override
    public UnionUntypedCase voidValue(ScalarDataType scalarDataType) {
        return UnionUntypedCase.getInstance();
    }

    @Override
    public <T extends Enum> T enumValue(EnumDataType t) {
        String enumConst = this.getSafeText();
        String n = t.getSynthFullyQualifiedName();
        return (T)((Enum)((Object)ClassUtils.getByEnumConst(n, enumConst)));
    }

    @Override
    public <T extends Union> T unionValue(UnionDataType t) {
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(t.getSynthFullyQualifiedName());
        if (t.getUnionType() == UnionType.Tagged) {
            if (this.parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = this.parser.getCurrentName();
                if (fieldname != null && fieldname.equals(this.getCodecConfig().getMetaFieldPrefix() + JsonDataConsumer.MetaFieldTypeName)) {
                    this.parser.nextToken();
                    String type = this.getSafeText();
                    return (T)((Union)this.readType(Optional.of(cm), Optional.of(type), Collections.emptyMap()));
                }
                this.parser.pushBackLastToken();
                return (T)((Union)this.readType(Optional.of(cm), Optional.empty(), Collections.emptyMap()));
            }
        } else {
            return (T)((Union)this.readUntaggedValue(t.getSynthFullyQualifiedName()));
        }
        throw new AlfaRuntimeException(NoType);
    }

    @Override
    public <T> T metaValue(MetaDataType t) {
        return null;
    }

    @Override
    public <T extends AlfaObject> T objectValue(UdtDataType t) {
        try {
            return this.objectValue(t, Collections.emptyMap());
        }
        catch (AlfaRuntimeException a) {
            throw a.appendMessage(" at " + this.parser.getCurrentLocationStr());
        }
    }

    @Override
    public <T extends Record> T tupleValue(TupleDataType t) {
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(t.getSynthFullyQualifiedName());
        if (this.parser.currentToken() == JsonToken.START_OBJECT) {
            this.parser.nextToken();
            String fieldname = this.parser.getCurrentName();
            if (fieldname != null && fieldname.equals(this.getCodecConfig().getMetaFieldPrefix() + JsonDataConsumer.MetaFieldTypeName)) {
                this.parser.nextToken();
                String type = this.getSafeText();
                if (!t.getSynthFullyQualifiedName().equals(type)) {
                    throw new AlfaRuntimeException(this.getCodecConfig().getMetaFieldPrefix() + "type " + type + " mismatch with supplied type " + t.getSynthFullyQualifiedName());
                }
            } else {
                this.parser.pushBackLastToken();
            }
        }
        return (T)((Record)this.readType(Optional.of(cm), Optional.empty(), Collections.emptyMap()));
    }

    @Override
    public <T extends AlfaObject> T objectValue(UdtDataType t, Map<String, Function> templateFieldSuppliers) {
        Optional<ClassUtils.ClassMeta> cm = Optional.of(ClassUtils.getMeta(t.getFullyQualifiedName()));
        return this.objectValue(cm, templateFieldSuppliers);
    }

    @Override
    public <T extends AlfaObject> T objectValue(Optional<ClassUtils.ClassMeta> cm, Map<String, Function> templateFieldSuppliers) {
        if (cm.isPresent()) {
            UdtDataType ut = cm.get().getModel().getUdtDataType();
            if (ut.getUdtType() == UdtMetaType.enumType) {
                String enConst = this.getSafeText();
                if (enConst == null) {
                    throw new AlfaRuntimeException("Could not read enum value " + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
                }
                if (this.getCodecConfig().isVerbose()) {
                    this.log("Enum value:" + enConst);
                }
                return (T)((AlfaObject)((Object)ClassUtils.getByEnumConst(ut.getFullyQualifiedName(), enConst)));
            }
            if (ut.getUdtType() == UdtMetaType.nativeUdtType) {
                String nativeValue = this.getSafeText();
                if (this.getCodecConfig().isVerbose()) {
                    this.log("Native value:" + nativeValue);
                }
                Builder b = cm.get().getNewBuilder(super.getCodecConfig());
                b.modify(null, nativeValue);
                return b.build();
            }
            if (ut.getUdtType() == UdtMetaType.untaggedUnionType) {
                return this.readUntaggedValue(ut.getFullyQualifiedName());
            }
        }
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            if (this.parser.currentToken() == JsonToken.START_OBJECT) continue;
            String fieldname = this.parser.getCurrentName();
            if (fieldname != null && fieldname.equals(this.getCodecConfig().getMetaFieldPrefix() + JsonDataConsumer.MetaFieldTypeName)) {
                this.parser.nextToken();
                String type = this.getSafeText();
                return this.readType(cm, Optional.of(type), templateFieldSuppliers);
            }
            if (!cm.isPresent()) continue;
            this.parser.pushBackLastToken();
            return this.readType(cm, Optional.empty(), templateFieldSuppliers);
        }
        if (cm.isPresent()) {
            Collection flds = cm.get().getModel().getAllFieldsMeta().values();
            long optFlds = flds.stream().filter(e -> e.getDataType() instanceof OptionalDataType).count();
            if ((long)flds.size() == optFlds) {
                return cm.get().getNewBuilder(this.getCodecConfig()).build();
            }
        }
        throw new AlfaRuntimeException("Did not see valid JSON object. Current token:" + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
    }

    private <T extends AlfaObject> T readUntaggedValue(String fqn) {
        int tkn = this.parser.currentToken().id();
        ClassUtils.ClassMeta ucm = ClassUtils.getMeta(fqn);
        UntaggedUnionBuilder ub = (UntaggedUnionBuilder)ucm.getNewBuilder(super.getCodecConfig());
        if (tkn == JsonToken.VALUE_STRING.id()) {
            ub.setByType(this.getSafeText());
        } else if (tkn == JsonToken.VALUE_NUMBER_INT.id()) {
            long l = this.parser.getLongValue();
            if (l < Integer.MAX_VALUE) {
                ub.setByType((int)l);
            } else {
                ub.setByType(l);
            }
        } else if (tkn == JsonToken.VALUE_NUMBER_FLOAT.id()) {
            ub.setByType(this.parser.getDoubleValue());
        } else if (tkn == JsonToken.VALUE_FALSE.id() || tkn == JsonToken.VALUE_TRUE.id()) {
            ub.setByType(this.parser.getBooleanValue());
        } else if (tkn == JsonToken.START_OBJECT.id()) {
            JsonToken ntSkip = this.parser.nextToken();
            String ns = this.getSafeText();
            String cname = fqn.substring(0, fqn.lastIndexOf(".") + 1) + ns;
            T t = this.readType(Optional.of(ClassUtils.getMeta(cname)), Optional.empty(), Collections.emptyMap());
            JsonToken endSkip = this.parser.nextToken();
            ub.setByType(t);
        } else if (tkn != JsonToken.START_ARRAY.id()) {
            throw new AlfaRuntimeException("Did not see valid JSON object in untagged value for type " + fqn + " at " + String.valueOf(this.parser.getCurrentLocation()));
        }
        return ub.build();
    }

    private <K, V> Map<K, V> mapValueScalarKey(MapDataType dt, Function<DataSupplier, K> kc, Function<DataSupplier, V> vc) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        ScalarAsFieldSupplier con = new ScalarAsFieldSupplier(this.getCodecConfig());
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            if (this.parser.currentToken() == JsonToken.START_OBJECT) continue;
            K k = kc.apply(con);
            JsonToken t2 = this.parser.nextToken();
            V v = vc.apply(this);
            V old = m.put(k, v);
            if (old == null) continue;
            throw new AlfaRuntimeException(ConstraintType.Duplicate, "Duplicate key in map " + String.valueOf(k));
        }
        return Collections.unmodifiableMap(m);
    }

    @Override
    public <K, V> Map<K, V> mapValue(MapDataType dt, Function<DataSupplier, K> kc, Function<DataSupplier, V> vc) {
        boolean scalarKey = dt.getKeyType() instanceof ScalarDataType;
        if (scalarKey && this.jsonCfg.isWriteMapAsObject() && this.parser.currentToken() != JsonToken.START_OBJECT) {
            throw new AlfaRuntimeException("Expected map start, got " + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
        }
        if (this.parser.currentToken() == JsonToken.START_OBJECT) {
            return this.mapValueScalarKey(dt, kc, vc);
        }
        if (this.parser.currentToken() == JsonToken.START_ARRAY) {
            UdtDataType udt;
            ClassUtils.ClassMeta cm;
            if (dt.getKeyType() instanceof UdtDataType && (cm = ClassUtils.getMeta((udt = (UdtDataType)dt.getKeyType()).getFullyQualifiedName())).getModel().getUdtDataType().getUdtType() == UdtMetaType.enumType) {
                return this.mapValueScalarKey(dt, kc, vc);
            }
            long limit = Long.MAX_VALUE;
            if (dt.getSizeMax().isPresent()) {
                limit = dt.getSizeMax().get().intValue();
            }
            long counter = 0L;
            LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
            String kn = dt.getKeyName().orElse(JsonDataConsumer.CompoundMapKeyField);
            String vn = dt.getValueName().orElse(JsonDataConsumer.CompoundMapValField);
            while (this.parser.nextToken() != JsonToken.END_ARRAY) {
                this.parser.nextToken();
                String keyf = this.parser.getCurrentName();
                if (!keyf.equals(kn)) {
                    throw new AlfaRuntimeException(ConstraintType.UnknownField, "Unknown map key field name " + keyf);
                }
                this.parser.nextToken();
                K k = kc.apply(this);
                this.parser.nextToken();
                String valf = this.parser.getCurrentName();
                if (!valf.equals(vn)) {
                    throw new AlfaRuntimeException(ConstraintType.UnknownField, "Unknown map value field name " + valf);
                }
                this.parser.nextToken();
                V v = vc.apply(this);
                this.parser.nextToken();
                if (counter + 1L > limit) {
                    throw new AlfaRuntimeException(ConstraintType.OutsidePermittedRange, "Cannot insert to map<K,V>. Maximum limit " + limit + " reached on field '" + this.currentFieldName() + "'.");
                }
                V old = m.put(k, v);
                if (old != null) {
                    throw new AlfaRuntimeException(ConstraintType.Duplicate, "Duplicate key in map " + String.valueOf(k));
                }
                ++counter;
            }
            return Collections.unmodifiableMap(m);
        }
        throw new AlfaRuntimeException("Expected map or array start, got " + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
    }

    private void log(String m) {
        System.out.println(m);
    }

    private <T extends AlfaObject> T readType(Optional<ClassUtils.ClassMeta> expectedType, Optional<String> typeNameInData, Map<String, Function> templateFieldSuppliers) {
        ClassUtils.ClassMeta cm;
        if (expectedType.isPresent()) {
            if (typeNameInData.isPresent()) {
                ClassUtils.ClassMeta dataCm = ClassUtils.getMeta(typeNameInData.get());
                expectedType.get().assertCompatible(dataCm);
                cm = dataCm;
            } else {
                cm = expectedType.get();
            }
        } else if (typeNameInData.isPresent()) {
            cm = ClassUtils.getMeta(typeNameInData.get());
        } else {
            throw new AlfaRuntimeException("No expected type or type declared in the data");
        }
        if (typeNameInData.isPresent() && cm.getModel().getUdtDataType().getUdtType() == UdtMetaType.traitType) {
            throw new AlfaRuntimeException(ConstraintType.InvalidTypeForField, "Trait cannot be deserialized as a type " + cm.getModel().getUdtDataType().getFullyQualifiedName());
        }
        Builder builder = cm.getNewBuilder(super.getCodecConfig());
        Builder keyBuilder = null;
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            JsonToken t;
            if (this.parser.currentToken() == JsonToken.START_OBJECT) continue;
            if (this.parser.currentToken() == null) break;
            String fieldName = this.parser.getCurrentName();
            if (fieldName.startsWith(this.getCodecConfig().getMetaFieldPrefix()) && this.getCodecConfig().getFieldNameMapper().apply(fieldName) == null && !JsonDataConsumer.MetaFieldNames.contains(fieldName.substring(this.getCodecConfig().getMetaFieldPrefix().length()))) continue;
            if (fieldName.equals(this.getCodecConfig().getMetaFieldPrefix() + JsonDataConsumer.MetaFieldChecksum)) {
                this.parser.nextToken();
                TypeChecksum checksumInJson = new TypeChecksum(this.getSafeText());
                TypeChecksum localChecksum = new TypeChecksum(builder.descriptor().getChecksum());
                if (localChecksum.equals(checksumInJson) || localChecksum.getMandatoryOnly().equals(checksumInJson.getMandatoryOnly())) continue;
                throw new AlfaRuntimeException(ConstraintType.DataFormatError, "Incompatible checksums in JSON " + String.valueOf(checksumInJson) + " and locally " + String.valueOf(localChecksum));
            }
            if (this.getCodecConfig().isVerbose()) {
                this.log("Type = " + cm.getModel().getUdtDataType().getFullyQualifiedName() + " FieldName = " + fieldName);
            }
            String dollarType = this.getCodecConfig().getMetaFieldPrefix() + JsonDataConsumer.MetaFieldTypeName;
            if (cm.getModel().getUdtDataType().getUdtType() == UdtMetaType.entityType && fieldName.equals(this.getCodecConfig().getMetaFieldPrefix() + "key")) {
                TypeDescriptor km = cm.getModel().getEntityKeyModel().get();
                Key k = (Key)this.objectValue(km.getUdtDataType(), Collections.emptyMap());
                EntityBuilder eb = (EntityBuilder)((Object)builder);
                eb.set$key(k);
                continue;
            }
            if (dollarType.equals(fieldName) && this.getCodecConfig().isOutOfOrderTypeSpecifierAllowed()) {
                t = this.parser.nextToken();
                continue;
            }
            if (fieldName == null) continue;
            t = this.parser.nextToken();
            Function tmpl = templateFieldSuppliers.get(fieldName);
            if (tmpl != null) {
                Object val = tmpl.apply(this);
                builder.modify(fieldName, val);
                continue;
            }
            FieldMeta fieldMeta = cm.getModel().getAllFieldsMeta().get(fieldName);
            if (fieldMeta == null && this.getCodecConfig().getFieldNameMapper().apply(fieldName) != null) {
                fieldName = this.getCodecConfig().getFieldNameMapper().apply(fieldName);
                fieldMeta = cm.getModel().getAllFieldsMeta().get(fieldName);
            }
            if (fieldMeta == null) {
                if (cm.getModel().getUdtDataType().getUdtType() == UdtMetaType.entityType && cm.getModel().getEntityKeyModel().get().getAllFieldsMeta().keySet().contains(fieldName)) {
                    TypeDescriptor km = cm.getModel().getEntityKeyModel().get();
                    FieldMeta keyFieldMeta = km.getAllFieldsMeta().get(fieldName);
                    if (keyBuilder == null) {
                        keyBuilder = km.builder(this.getCodecConfig());
                    }
                    this.fieldValue(keyFieldMeta.getField(), keyBuilder, keyFieldMeta.getConsumer().get());
                    continue;
                }
                if (this.getCodecConfig().isSkipUnknownFields()) {
                    this.parser.skipChildren();
                    continue;
                }
                if (cm.getModel().getAnnotations().isPresent() && cm.getModel().getAnnotations().get().containsKey("SkipUnknownFields")) {
                    if (this.getCodecConfig().isVerbose()) {
                        this.log("Skipping unknown field as 'SkipUnknownFields' is set - " + fieldName);
                    }
                    this.parser.skipChildren();
                    continue;
                }
                ValidationAlert.ValidationAlertBuilder va = ValidationAlert.builder().setViolatedConstraint(Optional.of(ConstraintType.UnknownField)).setTypeName(Optional.of(cm.getTypeClass().getName())).setSourceInfo(Optional.of(this.parser.getCurrentLocationStr())).setFieldName(Optional.of(fieldName)).setMessage("Unknown field for type");
                this.getCodecConfig().getAssertListener().addFailure(va);
                continue;
            }
            try {
                this.fieldValue(fieldMeta.getField(), builder, fieldMeta.getConsumer().get());
            }
            catch (AlfaRuntimeException tx) {
                tx.setValidationErrorTypeName(cm.getModel().getUdtDataType().getFullyQualifiedName());
                this.getCodecConfig().getAssertListener().addFailure(tx.toValidationAlert("Failed to process field '" + fieldName + "'").setSourceInfo(Optional.of(this.parser.getCurrentLocationStr())));
            }
            catch (Throwable tx) {
                this.getCodecConfig().getAssertListener().addFailure(ValidationAlert.builder().setMessage(tx.getClass().getSimpleName() + ":" + tx.getMessage()).setViolatedConstraint(Optional.of(ConstraintType.DataFormatError)).setExceptionDetails(Optional.of(Logger.stacktraceToString(tx, 5))).setSourceInfo(Optional.of(this.parser.getCurrentLocationStr())));
            }
        }
        if (keyBuilder != null) {
            EntityBuilder eb = (EntityBuilder)((Object)builder);
            eb.set$key(keyBuilder.build());
        }
        Object t = builder.build();
        return t;
    }

    @Override
    public <T> Set<T> setValue(SetDataType mdt, Function<DataSupplier, T> c) {
        LinkedHashSet<T> l = new LinkedHashSet<T>();
        long limit = Long.MAX_VALUE;
        if (mdt.getSizeMax().isPresent()) {
            limit = mdt.getSizeMax().get().intValue();
        }
        long counter = 0L;
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            throw new AlfaRuntimeException("Expected array start, got " + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
        }
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            T v = c.apply(this);
            Utils.assertNotNull(v);
            if (counter + 1L > limit) {
                throw new AlfaRuntimeException(ConstraintType.OutsidePermittedRange, "Cannot insert to set<T>. Maximum limit " + limit + " reached on field '" + this.currentFieldName() + "'.");
            }
            l.add(v);
            ++counter;
        }
        return Collections.unmodifiableSet(l);
    }

    @Override
    public <T> List<T> listValue(ListDataType mdt, Function<DataSupplier, T> c) {
        ArrayList<T> l = new ArrayList<T>();
        long limit = Long.MAX_VALUE;
        if (mdt.getSizeMax().isPresent()) {
            limit = mdt.getSizeMax().get().intValue();
        }
        long counter = 0L;
        if (this.parser.currentToken() != JsonToken.START_ARRAY) {
            throw new AlfaRuntimeException("Expected array start, got " + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
        }
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            T v = c.apply(this);
            Utils.assertNotNull(v);
            if (counter + 1L > limit) {
                throw new AlfaRuntimeException(ConstraintType.OutsidePermittedRange, "Cannot insert to list<T>. Maximum limit " + limit + " reached on field '" + this.currentFieldName() + "'.");
            }
            l.add(v);
            ++counter;
        }
        l.trimToSize();
        return Collections.unmodifiableList(l);
    }

    @Override
    public <T> Compressed compressedValue(Function<DataSupplier, T> compressedConsumer) {
        byte[] bin = this.parser.getBinaryValue();
        return IntImpl.defaultCompressedFromValue(compressedConsumer, bin);
    }

    @Override
    public <T> Encrypted<T> encryptedValue(Function<DataSupplier, T> encryptedConsumer) {
        byte[] bin = this.parser.getBinaryValue();
        Encrypted<T> t = IntImpl.defaultEncryptedFromValue(encryptedConsumer, bin);
        return t;
    }

    @Override
    public <T> List<T> streamValue(StreamDataType std, Function<DataSupplier, T> c) {
        ArrayList<T> l = new ArrayList<T>();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            T v = c.apply(this);
            Utils.assertNotNull(v);
            l.add(v);
        }
        return Arrays.asList(l.toArray());
    }

    @Override
    public <T> Future<T> futureValue(FutureDataType fdt, Function<DataSupplier, T> c) {
        T t = c.apply(this);
        CompletableFuture<T> f = new CompletableFuture<T>();
        f.complete(t);
        return f;
    }

    @Override
    public <T> ITable tableValue(TabularDataType tdt, Function<DataSupplier, T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <L, R> Pair<L, R> pairValue(PairDataType edt, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        HashMap<String, Function> m = new HashMap<String, Function>();
        m.put("Left", lc);
        m.put("Right", rc);
        Object ov = this.objectValue(Optional.empty(), m);
        return (Pair)ov;
    }

    @Override
    public <L, R> Either<L, R> eitherValue(EitherDataType edt, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        HashMap<String, Function> m = new HashMap<String, Function>();
        m.put("Left", lc);
        m.put("Right", rc);
        Object ov = this.objectValue(Optional.empty(), m);
        return (Either)ov;
    }

    private LocalDate cachedDateValue(ScalarDataType dt, String val) {
        LocalDate sdt = localDates.get(val);
        if (sdt != null) {
            return sdt;
        }
        String v = "yyyy-MM-dd";
        try {
            if (dt.getStrPattern().isPresent()) {
                v = dt.getStrPattern().get();
                DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
                sdt = this.dateValue(dt, val, df, v);
            } else {
                sdt = this.dateValue(dt, val, DateTimeFormatter.ISO_DATE, v);
            }
        }
        catch (DateTimeException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, "Failed expected format '" + v + "' for date value '" + String.valueOf(e) + "'", e);
        }
        localDates.put(val, sdt);
        return sdt;
    }

    private LocalDate dateValue(ScalarDataType dt, String dateVal, DateTimeFormatter dtFmt, String fmtStr) {
        String k = dateVal + "|" + fmtStr;
        LocalDate ldt = localDates.get(k);
        if (ldt != null) {
            return ldt;
        }
        ldt = LocalDate.parse(dateVal, dtFmt);
        localDates.put(k, ldt);
        return ldt;
    }

    private DateTimeFormatter getFormat(String fmt) {
        DateTimeFormatter df = this.datetimeFormatMap.get(fmt);
        if (df == null) {
            df = DateTimeFormatter.ofPattern(fmt);
            this.datetimeFormatMap.put(fmt, df);
        }
        return df;
    }

    private String getSafeText() {
        if (this.parser.currentToken() != JsonToken.VALUE_STRING) {
            if (this.getCodecConfig().getJsonReaderRecovery().isPresent()) {
                String custom = this.getCodecConfig().getJsonReaderRecovery().get().stringValue(this.parser);
                if (custom != null) {
                    if (this.getCodecConfig().isVerbose()) {
                        this.log("read string:" + custom);
                    }
                    return this.interned(custom);
                }
                if (this.getCodecConfig().isVerbose()) {
                    this.log("got null string");
                }
            }
            throw new AlfaRuntimeException(ConstraintType.InvalidTypeForField, "Expected string, got " + String.valueOf(this.parser.currentToken()) + " at " + this.parser.getCurrentLocationStr());
        }
        String s = this.parser.getText();
        if (this.getCodecConfig().isVerbose()) {
            this.log("read string:" + s);
        }
        return this.interned(s);
    }

    private String interned(String s) {
        return s.length() < 50 ? s.intern() : s;
    }

    class ScalarAsFieldSupplier
    extends NoOpDataSupplier {
        @Override
        public <T extends AlfaObject> T objectValue(UdtDataType t) {
            String fn = JsonDataSupplier.this.parser.getCurrentName();
            return (T)((AlfaObject)((Object)ClassUtils.getByEnumConst(t.getFullyQualifiedName(), fn)));
        }

        protected ScalarAsFieldSupplier(CodecConfig jwc) {
            super(jwc);
        }

        @Override
        public int intValue(ScalarDataType sdt) {
            Integer i = Integer.valueOf(JsonDataSupplier.this.parser.getCurrentName());
            if (this.getCodecConfig().isVerbose()) {
                JsonDataSupplier.this.log("read int:" + i);
            }
            return i;
        }

        @Override
        public String stringValue(ScalarDataType scalarDataType) {
            String s = JsonDataSupplier.this.parser.getCurrentName();
            if (this.getCodecConfig().isVerbose()) {
                JsonDataSupplier.this.log("read string:" + s);
            }
            return s;
        }

        @Override
        public double doubleValue(ScalarDataType sdt) {
            return Double.valueOf(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public short shortValue(ScalarDataType sdt) {
            return Short.valueOf(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public long longValue(ScalarDataType sdt) {
            return Long.valueOf(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public byte byteValue(ScalarDataType sdt) {
            return super.byteValue(sdt);
        }

        @Override
        public char charValue(ScalarDataType sdt) {
            return JsonDataSupplier.this.parser.getCurrentName().charAt(0);
        }

        @Override
        public boolean booleanValue(ScalarDataType sdt) {
            boolean v = Boolean.valueOf(JsonDataSupplier.this.parser.getCurrentName());
            if (this.getCodecConfig().isVerbose()) {
                JsonDataSupplier.this.log("read boolean:" + v);
            }
            return v;
        }

        @Override
        public BigDecimal decimalValue(ScalarDataType sdt) {
            return new BigDecimal(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public LocalDate dateValue(ScalarDataType dt) {
            return JsonDataSupplier.this.cachedDateValue(dt, JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public LocalDateTime datetimeValue(ScalarDataType sdt) {
            return LocalDateTime.parse(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public ZonedDateTime datetimetzValue(ScalarDataType sdt) {
            return ZonedDateTime.parse(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public LocalTime timeValue(ScalarDataType sdt) {
            return LocalTime.parse(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public float floatValue(ScalarDataType sdt) {
            return Float.valueOf(JsonDataSupplier.this.parser.getCurrentName()).floatValue();
        }

        @Override
        public byte[] binaryValue(ScalarDataType sdt) {
            return super.binaryValue(sdt);
        }

        @Override
        public Duration durationValue(ScalarDataType sdt) {
            return Duration.parse(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public UUID uuidValue(ScalarDataType sdt) {
            return UUID.fromString(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public URI uriValue(ScalarDataType sdt) {
            return URI.create(JsonDataSupplier.this.parser.getCurrentName());
        }

        @Override
        public String patternValue(ScalarDataType sdt) {
            return JsonDataSupplier.this.parser.getCurrentName();
        }

        @Override
        public <T extends Enum> T enumValue(EnumDataType t) {
            return super.enumValue(t);
        }
    }
}

