/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum QualifiedIdentifierType implements Enum
{
    EnumReference("EnumReference", Optional.empty()),
    FieldReference("FieldReference", Optional.empty()),
    TypeReference("TypeReference", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, QualifiedIdentifierType> mappings;

    private QualifiedIdentifierType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static QualifiedIdentifierType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, QualifiedIdentifierType> m = new HashMap<String, QualifiedIdentifierType>();
            for (QualifiedIdentifierType c : QualifiedIdentifierType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return QualifiedIdentifierTypeDescriptor.INSTANCE;
    }

    public static final class QualifiedIdentifierTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.QualifiedIdentifierType";
        public static QualifiedIdentifierTypeDescriptor INSTANCE = new QualifiedIdentifierTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_ENUMREFERENCE = 0;
        public static final String FIELD_ENUMREFERENCE = "EnumReference";
        public static final short FIELD_ID_FIELDREFERENCE = 1;
        public static final String FIELD_FIELDREFERENCE = "FieldReference";
        public static final short FIELD_ID_TYPEREFERENCE = 2;
        public static final String FIELD_TYPEREFERENCE = "TypeReference";
        private ScalarDataType _enumReferenceType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _fieldReferenceType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _typeReferenceType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta enumReferenceMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._enumReferenceType, "EnumReference", Optional.empty());
        public FieldMeta fieldReferenceMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._fieldReferenceType, "FieldReference", Optional.empty());
        public FieldMeta typeReferenceMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._typeReferenceType, "TypeReference", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<QualifiedIdentifierType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(QualifiedIdentifierTypeDescriptor.FIELD_ENUMREFERENCE, enumReferenceMeta);
                this.put(QualifiedIdentifierTypeDescriptor.FIELD_FIELDREFERENCE, fieldReferenceMeta);
                this.put(QualifiedIdentifierTypeDescriptor.FIELD_TYPEREFERENCE, typeReferenceMeta);
            }
        });

        public Optional<Function<QualifiedIdentifierType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<QualifiedIdentifierType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_ENUMREFERENCE;
                }
                case 1: {
                    return FIELD_FIELDREFERENCE;
                }
                case 2: {
                    return FIELD_TYPEREFERENCE;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "61ca4596:";
        }
    }
}

