/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.blk;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum CheckType implements Enum
{
    String("String", Optional.empty()),
    Number("Number", Optional.empty()),
    Boolean("Boolean", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, CheckType> mappings;

    private CheckType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static CheckType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, CheckType> m = new HashMap<String, CheckType>();
            for (CheckType c : CheckType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return CheckTypeDescriptor.INSTANCE;
    }

    public static final class CheckTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.blk.CheckType";
        public static CheckTypeDescriptor INSTANCE = new CheckTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_STRING = 0;
        public static final String FIELD_STRING = "String";
        public static final short FIELD_ID_NUMBER = 1;
        public static final String FIELD_NUMBER = "Number";
        public static final short FIELD_ID_BOOLEAN = 2;
        public static final String FIELD_BOOLEAN = "Boolean";
        private ScalarDataType _stringType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _numberType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _booleanType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta stringMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._stringType, "String", Optional.empty());
        public FieldMeta numberMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._numberType, "Number", Optional.empty());
        public FieldMeta _booleanMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._booleanType, "Boolean", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<CheckType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(CheckTypeDescriptor.FIELD_STRING, stringMeta);
                this.put(CheckTypeDescriptor.FIELD_NUMBER, numberMeta);
                this.put(CheckTypeDescriptor.FIELD_BOOLEAN, _booleanMeta);
            }
        });

        public Optional<Function<CheckType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<CheckType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_STRING;
                }
                case 1: {
                    return FIELD_NUMBER;
                }
                case 2: {
                    return FIELD_BOOLEAN;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "465bdc5c:";
        }
    }
}

