/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import java.util.Objects;

public final class TypeChecksum {
    private final String all;
    private final String mandatoryOnly;

    public TypeChecksum(String s) {
        String[] sp = s.split(":");
        this.all = sp[0];
        if (s.indexOf(":") == -1) {
            throw new AlfaRuntimeException("Invalid checksum string " + s);
        }
        this.mandatoryOnly = sp.length == 1 || sp[1].length() == 0 ? this.all : sp[1];
    }

    public String getAll() {
        return this.all;
    }

    public String getMandatoryOnly() {
        return this.mandatoryOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeChecksum that = (TypeChecksum)o;
        return Objects.equals(this.all, that.all) && Objects.equals(this.mandatoryOnly, that.mandatoryOnly);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.mandatoryOnly);
    }

    public String toString() {
        return this.getAll() + ":" + (this.all == this.mandatoryOnly ? "" : this.mandatoryOnly);
    }
}

