/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.codec;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.BuilderConfig;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.EntityBuilder;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.Holder;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.Logger;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Record;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.IMapBasedRecord;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.EnumDataType;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.MetaDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.PairDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.TupleDataType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;
import schemarise.alfa.runtime.model.UnionDataType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

public class MapBasedDataSupplier
extends DataSupplier {
    protected final Stack<Object> values = new Stack();
    private static Map<String, LocalDate> datesCache = new ConcurrentHashMap<String, LocalDate>();
    private Map<String, DateTimeFormatter> datetimeFormatMap = new HashMap<String, DateTimeFormatter>();

    public MapBasedDataSupplier(CodecConfig jwc, IMapBasedRecord gr) {
        super(jwc);
        this.values.push(gr);
    }

    @Override
    public int intValue(ScalarDataType scalarDataType) {
        Object v = this.values.peek();
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return Integer.parseInt(v.toString());
    }

    @Override
    public String stringValue(ScalarDataType scalarDataType) {
        return this.values.peek().toString();
    }

    @Override
    public double doubleValue(ScalarDataType scalarDataType) {
        Object v = this.values.peek();
        if (v instanceof Double) {
            return (Double)v;
        }
        return Double.parseDouble(v.toString());
    }

    @Override
    public short shortValue(ScalarDataType scalarDataType) {
        Object v = this.values.peek();
        if (v instanceof Short) {
            return (Short)v;
        }
        return Short.parseShort(v.toString());
    }

    @Override
    public long longValue(ScalarDataType scalarDataType) {
        Object v = this.values.peek();
        if (v instanceof Short) {
            return (Long)this.values.peek();
        }
        return Long.parseLong(v.toString());
    }

    @Override
    public byte byteValue(ScalarDataType scalarDataType) {
        byte[] v = (byte[])this.values.peek();
        return v[0];
    }

    @Override
    public char charValue(ScalarDataType scalarDataType) {
        return this.values.peek().toString().charAt(0);
    }

    @Override
    public boolean booleanValue(ScalarDataType scalarDataType) {
        Object v = this.values.peek();
        if (v instanceof Boolean) {
            return (Boolean)this.values.peek();
        }
        return Boolean.parseBoolean(v.toString());
    }

    private DateTimeFormatter getFormat(String fmt) {
        DateTimeFormatter df = this.datetimeFormatMap.get(fmt);
        if (df == null) {
            df = DateTimeFormatter.ofPattern(fmt);
            this.datetimeFormatMap.put(fmt, df);
        }
        return df;
    }

    @Override
    public BigDecimal decimalValue(ScalarDataType scalarDataType) {
        return new BigDecimal(this.values.peek().toString());
    }

    @Override
    public LocalDate dateValue(ScalarDataType dt) {
        String val = this.values.peek().toString();
        LocalDate sdt = datesCache.get(val);
        if (sdt != null) {
            return sdt;
        }
        if (dt.getStrPattern().isPresent()) {
            DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
            sdt = LocalDate.parse(this.values.peek().toString(), df);
        } else {
            sdt = LocalDate.parse(this.values.peek().toString());
        }
        datesCache.put(val, sdt);
        return sdt;
    }

    @Override
    public LocalDateTime datetimeValue(ScalarDataType scalarDataType) {
        return LocalDateTime.parse(this.values.peek().toString());
    }

    @Override
    public ZonedDateTime datetimetzValue(ScalarDataType scalarDataType) {
        return ZonedDateTime.parse(this.values.peek().toString());
    }

    @Override
    public LocalTime timeValue(ScalarDataType scalarDataType) {
        return LocalTime.parse(this.values.peek().toString());
    }

    @Override
    public float floatValue(ScalarDataType scalarDataType) {
        return ((Float)this.values.peek()).floatValue();
    }

    @Override
    public byte[] binaryValue(ScalarDataType scalarDataType) {
        return (byte[])this.values.peek();
    }

    @Override
    public Duration durationValue(ScalarDataType scalarDataType) {
        return Duration.parse(this.values.peek().toString());
    }

    @Override
    public NormalizedPeriod periodValue(ScalarDataType scalarDataType) {
        return NormalizedPeriod.of(this.values.peek().toString());
    }

    @Override
    public UUID uuidValue(ScalarDataType scalarDataType) {
        return UUID.fromString(this.values.peek().toString());
    }

    @Override
    public URI uriValue(ScalarDataType scalarDataType) {
        return URI.create(this.values.peek().toString());
    }

    @Override
    public String patternValue(ScalarDataType scalarDataType) {
        return this.values.peek().toString();
    }

    @Override
    public UnionUntypedCase voidValue(ScalarDataType scalarDataType) {
        return UnionUntypedCase.getInstance();
    }

    @Override
    public <T extends Record> T tupleValue(TupleDataType t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Enum> T enumValue(EnumDataType t) {
        String enConst = (String)this.values.peek();
        Enum d = (Enum)((Object)ClassUtils.getByEnumConst(t.getSynthFullyQualifiedName(), enConst));
        return (T)d;
    }

    @Override
    public <T extends Union> T unionValue(UnionDataType t) {
        IMapBasedRecord gr = (IMapBasedRecord)this.values.peek();
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(gr.getFullName());
        return (T)((Union)this.objectValue(Optional.of(cm), Collections.emptyMap()));
    }

    @Override
    public <T> T metaValue(MetaDataType t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends AlfaObject> T objectValue(UdtDataType t) {
        return this.objectValue(t, Collections.emptyMap());
    }

    public <T extends Enum> T enumValue(UdtDataType t) {
        String enConst = (String)this.values.peek();
        return (T)((Enum)((Object)ClassUtils.getByEnumConst(t.getFullyQualifiedName(), enConst)));
    }

    @Override
    public <T extends AlfaObject> T objectValue(UdtDataType t, Map<String, Function> templateFieldSuppliers) {
        if (t.getUdtType() == UdtMetaType.enumType) {
            return this.enumValue(t);
        }
        IMapBasedRecord gr = (IMapBasedRecord)this.convertObject(this.values.peek());
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(gr.getFullName());
        return this.objectValue(Optional.of(cm), templateFieldSuppliers);
    }

    @Override
    public <T extends AlfaObject> T objectValue(Optional<ClassUtils.ClassMeta> cmOpt, Map<String, Function> templateFieldSuppliers) {
        ClassUtils.ClassMeta cm = cmOpt.get();
        return this.readType(cm, templateFieldSuppliers);
    }

    private Object processUnionField(Builder builder, String fieldName, IDataType unionTypeMeta) {
        if (unionTypeMeta instanceof OptionalDataType) {
            OptionalDataType odt = (OptionalDataType)unionTypeMeta;
            Object obj = this.processUnionField(builder, fieldName, odt.getComponentType());
            return Optional.of(obj);
        }
        if (unionTypeMeta instanceof ListDataType) {
            ListDataType odt = (ListDataType)unionTypeMeta;
            Object obj = this.processUnionField(builder, fieldName, odt.getComponentType());
            return Arrays.asList(obj);
        }
        if (unionTypeMeta instanceof UnionDataType) {
            UnionDataType udt = (UnionDataType)unionTypeMeta;
            ClassUtils.ClassMeta unionMeta = ClassUtils.getMeta(udt.getSynthFullyQualifiedName());
            FieldMeta unionFieldMeta = unionMeta.getModel().getAllFieldsMeta().get(fieldName);
            Builder unionBuilder = unionMeta.getNewBuilder(BuilderConfig.getInstance());
            this.fieldValue(unionFieldMeta.getField(), unionBuilder, unionFieldMeta.getConsumer().get());
            return unionBuilder.build();
        }
        UdtDataType udt = (UdtDataType)unionTypeMeta;
        ClassUtils.ClassMeta unionMeta = ClassUtils.getMeta(udt.getFullyQualifiedName());
        FieldMeta unionFieldMeta = unionMeta.getModel().getAllFieldsMeta().get(fieldName);
        Builder unionBuilder = unionMeta.getNewBuilder(BuilderConfig.getInstance());
        this.fieldValue(unionFieldMeta.getField(), unionBuilder, unionFieldMeta.getConsumer().get());
        return unionBuilder.build();
    }

    private <T extends AlfaObject> T readType(ClassUtils.ClassMeta cm, Map<String, Function> templateFieldSuppliers) {
        EntityBuilder eb;
        Builder builder = cm.getNewBuilder(super.getCodecConfig());
        IMapBasedRecord gr = (IMapBasedRecord)this.convertObject(this.values.peek());
        String keyField = this.getCodecConfig().getMetaFieldPrefix() + "key";
        TypeDescriptor _keyDesc = null;
        ClassUtils.ClassMeta _keyMeta = null;
        Builder _kbuilder = null;
        if (cm.getModel().getUdtDataType().getUdtType() == UdtMetaType.entityType) {
            _keyDesc = cm.getModel().getEntityKeyModel().get();
            _keyMeta = ClassUtils.getMeta(_keyDesc.getUdtDataType().getFullyQualifiedName());
            _kbuilder = _keyMeta.getNewBuilder(this.getCodecConfig());
        }
        TypeDescriptor keyDesc = _keyDesc;
        ClassUtils.ClassMeta keyMeta = _keyMeta;
        Builder kbuilder = _kbuilder;
        Holder<Key> k = new Holder<Key>();
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String fieldName : gr.getFields()) {
            try {
                if (cm.getModel().getUdtDataType().getUdtType() == UdtMetaType.entityType && fieldName.equals(keyField)) {
                    Object ak = gr.get(keyField);
                    this.values.push(ak);
                    k.setValue((Key)this.objectValue(keyDesc.getUdtDataType(), Collections.emptyMap()));
                    this.values.pop();
                    continue;
                }
                if (cm.getModel().getUdtDataType().getUdtType() == UdtMetaType.entityType && !this.getCodecConfig().isWriteEntityKeyAsObject() && keyDesc.getAllFieldsMeta().containsKey(fieldName)) {
                    this.readTypeField(keyMeta, templateFieldSuppliers, kbuilder, gr, fieldName);
                    continue;
                }
                if (gr.get(fieldName) == null && cm.getModel().getAllFieldsMeta().containsKey(fieldName) && !(cm.getModel().getAllFieldsMeta().get(fieldName).getDataType() instanceof OptionalDataType)) {
                    throw new Exception("Mandatory value missing");
                }
                this.readTypeField(cm, templateFieldSuppliers, builder, gr, fieldName);
            }
            catch (Exception t) {
                String msg = t.getMessage() == null ? t.getClass().getName() : t.getMessage();
                String err = "Field:" + fieldName + "; Value:" + String.valueOf(gr.get(fieldName)) + "; Error:" + msg;
                if (Logger.getOrCreateDefault().isTraceEnabled()) {
                    t.printStackTrace();
                }
                errors.add((CallSite)((Object)err));
            }
        }
        if (errors.size() > 0) {
            throw new RuntimeException(String.join((CharSequence)" | ", errors));
        }
        if (k.isSet()) {
            eb = (EntityBuilder)((Object)builder);
            eb.set$key(k.getValue());
        } else if (kbuilder != null) {
            eb = (EntityBuilder)((Object)builder);
            eb.set$key(kbuilder.build());
        }
        return builder.build();
    }

    private void readTypeField(ClassUtils.ClassMeta cm, Map<String, Function> templateFieldSuppliers, Builder builder, IMapBasedRecord gr, String fieldName) {
        Function tmpl = templateFieldSuppliers.get(fieldName);
        if (tmpl != null) {
            Object val = tmpl.apply(this);
            builder.modify(fieldName, val);
        } else {
            FieldMeta fieldMeta = cm.getModel().getAllFieldsMeta().get(fieldName);
            if (!this.getCodecConfig().isSkipUnknownFields() || fieldMeta != null) {
                if (fieldMeta == null) {
                    throw new AlfaRuntimeException(ConstraintType.UnknownField, "Unknown field '" + fieldName + "' in " + gr.getFullName());
                }
                this.values.push(this.convertObject(gr.get(fieldName)));
                this.fieldValue(fieldMeta.getField(), builder, fieldMeta.getConsumer().get());
                this.values.pop();
            }
        }
    }

    protected Object convertObject(Object o) {
        return o;
    }

    @Override
    public <K, V> Map<K, V> mapValue(MapDataType t, Function<DataSupplier, K> kc, Function<DataSupplier, V> vc) {
        Object o = this.values.peek();
        if (o instanceof Map) {
            Map l = (Map)this.values.peek();
            LinkedHashMap res = new LinkedHashMap(l.size());
            l.forEach((k, v) -> {
                this.values.push(this.parseStringToType(t.getKeyType(), k));
                Object decodedKey = kc.apply(this);
                this.values.pop();
                this.values.push(v);
                Object decodedVal = vc.apply(this);
                this.values.pop();
                res.put(decodedKey, decodedVal);
            });
            return res;
        }
        List l = (List)this.values.peek();
        LinkedHashMap res = new LinkedHashMap(l.size());
        l.forEach(e -> {
            IMapBasedRecord rec = (IMapBasedRecord)this.convertObject(e);
            String keyName = t.getKeyName().orElse("key");
            String valName = t.getValueName().orElse("val");
            Object k = rec.get(keyName);
            Object v = rec.get(valName);
            this.values.push(k);
            Object decodedKey = kc.apply(this);
            this.values.pop();
            this.values.push(v);
            Object decodedVal = vc.apply(this);
            this.values.pop();
            res.put(decodedKey, decodedVal);
        });
        return res;
    }

    private Object parseStringToType(IDataType keyType, Object k) {
        ScalarDataType sdt = (ScalarDataType)keyType;
        String s = k.toString();
        switch (sdt.getScalarType()) {
            case stringType: {
                return s;
            }
            case intType: {
                return Integer.parseInt(s);
            }
            case shortType: {
                return Short.parseShort(s);
            }
            case longType: {
                return Long.parseLong(s);
            }
            case doubleType: {
                return Double.parseDouble(s);
            }
            case decimalType: {
                return new BigDecimal(s);
            }
            case uuidType: {
                return UUID.fromString(s);
            }
            case datetimeType: {
                return LocalDateTime.parse(s);
            }
            case dateType: {
                return LocalDate.parse(s);
            }
            case timeType: {
                return LocalTime.parse(s);
            }
            case durationType: {
                return NormalizedPeriod.of(Period.parse(s));
            }
            case booleanType: {
                return Boolean.parseBoolean(s);
            }
        }
        throw new AlfaRuntimeException("Unhandled type " + s);
    }

    @Override
    public <T> Set<T> setValue(SetDataType f, Function<DataSupplier, T> consumer) {
        List l = (List)this.values.peek();
        LinkedHashSet res = new LinkedHashSet(l.size());
        l.forEach(e -> {
            this.values.push(e);
            res.add(consumer.apply(this));
            this.values.pop();
        });
        return res;
    }

    @Override
    public <T> List<T> listValue(ListDataType f, Function<DataSupplier, T> consumer) {
        Object o = this.values.peek();
        if (o instanceof List) {
            List l = (List)this.values.peek();
            ArrayList res = new ArrayList(l.size());
            l.forEach(e -> {
                this.values.push(e);
                res.add(consumer.apply(this));
                this.values.pop();
            });
            return res;
        }
        ArrayList<T> res = new ArrayList<T>(1);
        res.add(consumer.apply(this));
        return res;
    }

    @Override
    public <T> Optional<T> optionalValue(OptionalDataType f, Function<DataSupplier, T> c) {
        Object p = this.values.peek();
        if (p != null) {
            if (p instanceof String && ((String)p).length() == 0 && f.getComponentType() instanceof ScalarDataType && ((ScalarDataType)f.getComponentType()).getScalarType() != ScalarType.stringType) {
                return Optional.empty();
            }
            return Optional.of(c.apply(this));
        }
        return Optional.empty();
    }

    @Override
    public <T> Compressed compressedValue(Function<DataSupplier, T> compressedConsumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Encrypted<T> encryptedValue(Function<DataSupplier, T> encryptedConsumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> streamValue(StreamDataType std, Function<DataSupplier, T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> futureValue(FutureDataType fdt, Function<DataSupplier, T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ITable tableValue(TabularDataType tdt, Function<DataSupplier, T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <L, R> Pair<L, R> pairValue(PairDataType edt, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <L, R> Either<L, R> eitherValue(EitherDataType edt, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        throw new UnsupportedOperationException();
    }
}

