/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.codec.table;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Holder;
import com.schemarise.alfa.runtime.ILogger;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.Logger;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime_int.IntImpl;
import com.schemarise.alfa.runtime_int.mstream.DefaultBlockingStream;
import com.univocity.parsers.common.ResultIterator;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;

public class TableCodec {
    public static ITable toTable(Collection<? extends AlfaObject> alfaObjects) {
        return IntImpl.getTableCodecInstance().toTable(alfaObjects);
    }

    public static ITable toTable(AlfaObject alfaObject) {
        return IntImpl.getTableCodecInstance().toTable(alfaObject);
    }

    public static <T extends AlfaObject> Stream<T> importRowBasedObjects(CodecConfig bc, String expectedType, Optional<List<String>> dataColumnNames, Stream<List<Object>> rowBasedData, Map<String, Function<Object, Object>> preProcessors) {
        return IntImpl.getTableCodecInstance().importRowBasedObjects(bc, expectedType, dataColumnNames, rowBasedData, preProcessors);
    }

    public static <T extends AlfaObject> T importRowBasedObject(CodecConfig bc, String expectedType, Optional<List<String>> dataColumnNames, List<Object> rowBasedData, String sourceLineInfo, Map<String, Function<Object, Object>> preProcessors) {
        return IntImpl.getTableCodecInstance().importRowBasedObject(bc, expectedType, dataColumnNames, rowBasedData, sourceLineInfo, preProcessors);
    }

    public static <T extends AlfaObject> Stream<T> importCsv(Path path, CsvReaderConfig csvCfg, CodecConfig bc, String expectedType, Optional<List<String>> dataColumnNames, Map<String, Function<Object, Object>> preProcessors) throws Exception {
        InputStream s = TableCodec.readAsStream(path);
        Stream<T> res = TableCodec.importCsv(s, csvCfg, bc, expectedType, dataColumnNames, preProcessors);
        return res;
    }

    public static <T extends AlfaObject> Stream<T> importCsv(InputStream is, CsvReaderConfig csvCfg, CodecConfig cc, String expectedType, Optional<List<String>> dataColumnNames, Map<String, Function<Object, Object>> preProcessors) {
        DefaultBlockingStream queue = new DefaultBlockingStream();
        Runnable r = () -> {
            CsvParser p = new CsvParser(csvCfg.getCsvParserSettings());
            ResultIterator it = p.iterate(is).iterator();
            AtomicLong rowsRead = new AtomicLong();
            AtomicLong rowsProcessed = new AtomicLong();
            Holder<Optional> colnames = new Holder<Optional>(dataColumnNames);
            while (it.hasNext()) {
                String[] csvline = (String[])it.next();
                long rowNo = rowsRead.incrementAndGet();
                if (rowNo == 1L && csvCfg.isHasHeader()) {
                    if (csvCfg.isUseHeader()) {
                        if (dataColumnNames.isPresent()) {
                            throw new AlfaRuntimeException("If CSV use-header is set, list of data-columns-names cannot be set");
                        }
                        colnames.setValue(Optional.of(Arrays.asList(csvline)));
                    }
                    rowsProcessed.incrementAndGet();
                    continue;
                }
                cc.getExecutorService().submit(() -> {
                    AlfaObject ax = null;
                    try {
                        long rowsSoFar = cc.getAssertListener().incrementTotalRecords();
                        ax = (AlfaObject)TableCodec.importRowBasedObject(cc, expectedType, (Optional)colnames.getValue(), Arrays.asList(csvline), "Line:" + rowsSoFar, preProcessors);
                        queue.deposit(ax);
                    }
                    catch (AlfaRuntimeException t) {
                        cc.getAssertListener().addFailure(t.toValidationAlert("Failed to process line no " + rowNo));
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage() == null ? t.getClass().getName() : t.getMessage();
                        cc.getAssertListener().addFailure(ValidationAlert.builder().setMessage("Failed to process line " + rowNo + ". " + msg));
                        ILogger l = Logger.getOrCreateDefault();
                        if (l.isTraceEnabled()) {
                            l.trace(Logger.stacktraceToString(t, 20));
                        }
                    }
                    finally {
                        rowsProcessed.incrementAndGet();
                    }
                    return ax;
                });
            }
            TableCodec.wait(10, false, 6000, rowsRead, rowsProcessed, expectedType);
            TableCodec.wait(5000, true, 720, rowsRead, rowsProcessed, expectedType);
            if (rowsRead.get() != rowsProcessed.get()) {
                Logger.getOrCreateDefault().error("Did not complete in 10 minutes. Exit processing " + expectedType);
            }
            queue.deposit(null);
        };
        cc.getExecutorService().submit(r);
        return queue.getStream();
    }

    private static void wait(int interval, boolean log, int limit, AtomicLong rowsRead, AtomicLong rowsProcessed, String expectedType) {
        long iterations = 0L;
        while (rowsRead.get() != rowsProcessed.get()) {
            try {
                Thread.sleep(interval);
                if (++iterations > (long)limit) break;
                if (!log) continue;
                Logger.getOrCreateDefault().info("Reading " + expectedType + " tabular data. " + rowsRead.get() + " of " + rowsRead.get());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static InputStream readAsStream(Path path) throws Exception {
        if (path.toString().endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(path.toFile());
            FileInputStream fileInputStream = new FileInputStream(path.toFile());
            ZipInputStream zin = new ZipInputStream(fileInputStream);
            return zipFile.getInputStream(zin.getNextEntry());
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    private static class BufferedReaderIterator
    implements Iterator<String[]> {
        private BufferedReader br;
        private String line;

        public BufferedReaderIterator(BufferedReader aBR) {
            this.br = aBR;
            this.br.getClass();
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String[] next() {
            String retval = this.line;
            this.advance();
            return retval.split(",");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on BufferedReader iteration.");
        }

        private void advance() {
            try {
                this.line = this.br.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class CsvReaderConfig {
        private CsvParserSettings _csvParserSettings = new CsvParserSettings();
        private boolean hasHeader;
        private boolean useHeader;

        public boolean isHasHeader() {
            return this.hasHeader;
        }

        public boolean isUseHeader() {
            return this.useHeader;
        }

        public static CsvReaderConfig defaultCsvReaderConfig() {
            return new CsvReaderConfig();
        }

        public void setCsvHasHeader(boolean hasHeader) {
            this.hasHeader = hasHeader;
        }

        public void setCsvUseHeader(boolean useHeader) {
            this.useHeader = useHeader;
        }

        public CsvReaderConfig() {
            this._csvParserSettings.setHeaderExtractionEnabled(false);
        }

        public void setColumnDelimiter(String d) {
            ((CsvFormat)this._csvParserSettings.getFormat()).setDelimiter(d);
        }

        public CsvParserSettings getCsvParserSettings() {
            return this._csvParserSettings;
        }

        public void setCsvParser(CsvParserSettings csvParser) {
            this._csvParserSettings = csvParser;
        }
    }
}

