/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.NoOpDataConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.SetDataType;

public class VectorCloner
extends NoOpDataConsumer {
    private Stack<Object> entries = new Stack();

    public static <T> List<T> immutableList(IBuilderConfig bc, BiConsumer<List<T>, DataConsumer> supp, List<T> f1) {
        if (f1 == null) {
            return f1;
        }
        if (!bc.shouldCloneCollectionsOnBuild()) {
            return Collections.unmodifiableList(f1);
        }
        VectorCloner consumer = new VectorCloner();
        supp.accept(f1, consumer);
        List l = (List)consumer.entries.pop();
        return l;
    }

    public static <T> Set<T> immutableSet(IBuilderConfig bc, BiConsumer<Set<T>, DataConsumer> supp, Set<T> f1) {
        if (f1 == null) {
            return f1;
        }
        if (!bc.shouldCloneCollectionsOnBuild()) {
            return Collections.unmodifiableSet(f1);
        }
        VectorCloner consumer = new VectorCloner();
        supp.accept(f1, consumer);
        Set l = (Set)consumer.entries.pop();
        return l;
    }

    public static <K, V> Map<K, V> immutableMap(IBuilderConfig bc, BiConsumer<Map<K, V>, DataConsumer> supp, Map<K, V> f1) {
        if (f1 == null) {
            return f1;
        }
        if (!bc.shouldCloneCollectionsOnBuild()) {
            return Collections.unmodifiableMap(f1);
        }
        VectorCloner consumer = new VectorCloner();
        supp.accept(f1, consumer);
        Map l = (Map)consumer.entries.pop();
        return l;
    }

    private boolean isVector(IDataType t) {
        return t instanceof ListDataType || t instanceof MapDataType || t instanceof SetDataType;
    }

    @Override
    public <T> void consume(ListDataType dt, List<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        ArrayList<Object> result;
        IDataType ct = dt.getComponentType();
        if (this.isVector(ct)) {
            result = new ArrayList(v.size());
            v.forEach(e -> {
                elementConsumer.accept(e, this);
                result.add(this.entries.pop());
            });
        } else {
            result = new ArrayList<T>(v);
        }
        this.entries.push(Collections.unmodifiableList(result));
    }

    @Override
    public <K, V> void consume(MapDataType dt, Map<K, V> v, BiConsumer<K, DataConsumer> keyConsumer, BiConsumer<V, DataConsumer> valueConsumer) {
        LinkedHashMap result;
        IDataType ct = dt.getValueType();
        if (this.isVector(ct)) {
            result = new LinkedHashMap(v.size());
            v.entrySet().forEach(e -> {
                valueConsumer.accept(e.getValue(), this);
                result.put(e.getKey(), this.entries.pop());
            });
        } else {
            result = new LinkedHashMap(v);
        }
        this.entries.push(Collections.unmodifiableMap(result));
    }

    @Override
    public <T> void consume(SetDataType dt, Set<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        HashSet<Object> result;
        IDataType ct = dt.getComponentType();
        if (this.isVector(ct)) {
            result = new HashSet(v.size());
            v.forEach(e -> {
                elementConsumer.accept(e, this);
                result.add(this.entries.pop());
            });
        } else {
            result = new HashSet<T>(v);
        }
        this.entries.push(Collections.unmodifiableSet(result));
    }
}

