/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.Field;
import schemarise.alfa.runtime.model.IDataType;

public class FieldMeta<T> {
    private final Field field;
    private final Optional<BiConsumer<T, DataConsumer>> fieldTypeSupplier;
    private final Optional<BiConsumer<Builder, DataSupplier>> fieldTypeConsumer;
    private final Optional<Map<String, Expression>> annotations;
    private final Optional<BiConsumer<Builder, DataSupplier>> fieldConsumer;
    private final Optional<BiConsumer<T, DataConsumer>> fieldSupplier;

    public FieldMeta(Optional<BiConsumer<T, DataConsumer>> supplier, Optional<BiConsumer<Builder, DataSupplier>> consumer, Optional<BiConsumer<T, DataConsumer>> fieldTypeSupplier, Optional<BiConsumer<Builder, DataSupplier>> fieldTypeConsumer, IDataType type, String name, Optional<Map<String, Expression>> annotations) {
        this.field = Field.builder().setName(name).setDataType(type).build();
        this.fieldConsumer = consumer;
        this.fieldSupplier = supplier;
        this.fieldTypeSupplier = fieldTypeSupplier;
        this.fieldTypeConsumer = fieldTypeConsumer;
        this.annotations = annotations;
    }

    public FieldMeta(Optional<BiConsumer<T, DataConsumer>> supplier, Optional<BiConsumer<Builder, DataSupplier>> consumer, Optional<BiConsumer<T, DataConsumer>> fieldTypeSupplier, Optional<BiConsumer<Builder, DataSupplier>> fieldTypeConsumer, Field f) {
        this.field = f;
        this.fieldConsumer = consumer;
        this.fieldSupplier = supplier;
        this.fieldTypeSupplier = fieldTypeSupplier;
        this.fieldTypeConsumer = fieldTypeConsumer;
        this.annotations = Optional.empty();
    }

    public Optional<Map<String, Expression>> getAnnotations() {
        return this.annotations;
    }

    public boolean hasAnnotation(String a) {
        return this.annotations.isPresent() && this.annotations.get().containsKey(a);
    }

    public Field getField() {
        return this.field;
    }

    public IDataType getDataType() {
        return this.field.getDataType();
    }

    public Optional<BiConsumer<Builder, DataSupplier>> getConsumer() {
        return this.fieldConsumer;
    }

    public Optional<BiConsumer<T, DataConsumer>> getSupplier() {
        return this.fieldSupplier;
    }

    public Optional<BiConsumer<Builder, DataSupplier>> getFieldTypeConsumer() {
        return this.fieldTypeConsumer;
    }

    public Optional<BiConsumer<T, DataConsumer>> getFieldTypeSupplier() {
        return this.fieldTypeSupplier;
    }
}

