/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import com.schemarise.alfa.runtime.utils.SizeEstimator;
import com.schemarise.alfa.runtime.utils.ToBuilderCreator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.Expression__IdentifierExpr;
import schemarise.alfa.runtime.model.Expression__LiteralExpr;
import schemarise.alfa.runtime.model.Expression__QualifiedIdentifierExpr;
import schemarise.alfa.runtime.model.Expression__SetExpr;
import schemarise.alfa.runtime.model.IExpression;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryFailure;
import schemarise.alfa.runtime.model.annotation.db.StorageMode;
import schemarise.alfa.runtime.model.annotation.db.TableDef;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;

public class AlfaUtils {
    private static Function<Map<String, Void>, List<ValidationAlert>> assertAllResultBuilder = s -> {
        s.forEach((k, v) -> {});
        return null;
    };

    private AlfaUtils() {
    }

    public static long estimateSize(AlfaObject alfaObject) {
        SizeEstimator se = new SizeEstimator(alfaObject);
        return se.getEstimatedSize();
    }

    public static void applyStreamingAsserts(String typeName, IBuilderConfig bc, Stream<AlfaObject> stream) {
        ClassUtils.getMeta(typeName).getNewBuilder(bc).applyStreamingAsserts(stream, bc.getExcludeAsserts());
    }

    public static void notNull(String name, Object o) {
        if (o == null) {
            throw new AlfaRuntimeException("Value " + name + " is null");
        }
    }

    public static long estimateSize(Set<String> strings, AlfaObject alfaObject) {
        SizeEstimator se = new SizeEstimator(strings, alfaObject);
        return se.getEstimatedSize();
    }

    public static <T extends Builder> T toBuilder(IBuilderConfig cfg, AlfaObject alfaObject) {
        ToBuilderCreator dc = new ToBuilderCreator(cfg, alfaObject);
        return (T)dc.newBuilder();
    }

    public static <T> Try<T> createTryFailure(String msg) {
        TryFailure tf = TryFailure.builder().setMessage(msg).build();
        return Try.builder().setFailure(tf).build();
    }

    public static <T> Try<T> createTryValue(T value) {
        return Try.builder().setResult(value).build();
    }

    public static <L, R> Either<L, R> createEitherLeft(L value) {
        return Either.builder().setLeft(value).build();
    }

    public static <L, R> Either<L, R> createEitherRight(R value) {
        return Either.builder().setRight(value).build();
    }

    public static <T, Void> Function<T, Void> buildAssertAllResult() {
        return assertAllResultBuilder;
    }

    public <T extends AlfaObject> Stream<String> validate(IBuilderConfig __builderConfig, Stream<T> _rows) {
        Stream<String> results = _rows.map(e -> {
            try {
                e.validate(__builderConfig);
                return Optional.of(null);
            }
            catch (AlfaRuntimeException ve) {
                Optional<String> res = Optional.of(ve.getMessage());
                return res;
            }
        }).filter(e -> e.isPresent()).map(e -> (String)e.get());
        return results;
    }

    public static Optional<TableDef> getTableAnnotation(AlfaObject ao) {
        return AlfaUtils.getTableAnnotation(ao.descriptor());
    }

    public static Optional<TableDef> getTableAnnotation(TypeDescriptor descriptor) {
        String d;
        if (!descriptor.getAnnotations().isPresent() || descriptor.getAnnotations().get().get("alfa.db.Table") == null) {
            return Optional.empty();
        }
        Map<String, IExpression> fields = descriptor.getAnnotations().get().get("alfa.db.Table").getObjectExpr().getFieldValues();
        TableDef.TableDefBuilder b = TableDef.builder();
        if (fields.containsKey("Name")) {
            d = (String)AlfaUtils.exprCaseValue(fields.get("Name"));
            b.setName(d.length() == 0 ? Optional.empty() : Optional.of(d));
        }
        if (fields.containsKey("PartitionExpression")) {
            b.setPartitionExpression((String)AlfaUtils.exprCaseValue(fields.get("PartitionExpression")));
        }
        if (fields.containsKey("PayloadColumnName")) {
            b.setPayloadColumnName((String)AlfaUtils.exprCaseValue(fields.get("PayloadColumnName")));
        }
        if (fields.containsKey("Schema")) {
            d = (String)AlfaUtils.exprCaseValue(fields.get("Schema"));
            b.setSchema(d.length() == 0 ? Optional.empty() : Optional.of(d));
        }
        if (fields.containsKey("StorageMode")) {
            String v = (String)AlfaUtils.exprCaseValue(fields.get("StorageMode"));
            String[] s = v.split("\\.");
            b.setStorageMode(StorageMode.valueOf(s[s.length - 1]));
        }
        if (fields.containsKey("Queryable")) {
            b.addAllQueryable((Set)AlfaUtils.exprCaseValue(fields.get("Queryable")));
        }
        if (fields.containsKey("ClusterFields")) {
            b.addAllClusterFields((Set)AlfaUtils.exprCaseValue(fields.get("ClusterFields")));
        }
        if (fields.containsKey("PartitionFields")) {
            b.addAllPartitionFields((Set)AlfaUtils.exprCaseValue(fields.get("PartitionFields")));
        }
        if (fields.containsKey("AllOptions")) {
            b.addAllOptions((Set)AlfaUtils.exprCaseValue(fields.get("AllOptions")));
        }
        return Optional.of(b.build());
    }

    private static Object exprCaseValue(IExpression e) {
        if (e instanceof Expression.CaseLiteralExpr) {
            Expression__LiteralExpr l = ((Expression.CaseLiteralExpr)e).getLiteralExpr();
            if (l.getExprType() == ScalarType.stringType) {
                return l.getValue().substring(1, l.getValue().length() - 1);
            }
            return l.getValue();
        }
        if (e instanceof Expression.CaseQualifiedIdentifierExpr) {
            Expression__QualifiedIdentifierExpr l = ((Expression.CaseQualifiedIdentifierExpr)e).getQualifiedIdentifierExpr();
            return String.join((CharSequence)".", l.getPath().toArray(new String[0]));
        }
        if (e instanceof Expression.CaseIdentifierExpr) {
            Expression__IdentifierExpr l = ((Expression.CaseIdentifierExpr)e).getIdentifierExpr();
            return l.getFieldName();
        }
        if (e instanceof Expression.CaseSetExpr) {
            Expression__SetExpr l = ((Expression.CaseSetExpr)e).getSetExpr();
            LinkedHashSet coll = new LinkedHashSet();
            l.getExpr().stream().forEach(se -> coll.add(AlfaUtils.exprCaseValue(se)));
            return coll;
        }
        throw new AlfaRuntimeException("Unhandled annotation expression translation " + String.valueOf(e));
    }
}

