/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.Library;
import com.schemarise.alfa.runtime.Service;
import com.schemarise.alfa.runtime.TypeDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import schemarise.alfa.runtime.model.Testcase;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

public class ClassUtils {
    private static Map<String, ClassMeta> classCache = new ConcurrentHashMap<String, ClassMeta>();
    private static InheritableThreadLocal<ClassLoader> classLoader = new InheritableThreadLocal();
    private static Map<String, Boolean> definedClasses = new HashMap<String, Boolean>();
    private static Map<String, Field> classFieldMap = new HashMap<String, Field>();

    public static void setContextClassLoader(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
        classLoader.set(cl);
    }

    public static java.lang.Enum getByEnumConst(String fullyQualifiedName) {
        int l = fullyQualifiedName.lastIndexOf(".");
        return ClassUtils.getByEnumConst(fullyQualifiedName.substring(0, l), fullyQualifiedName.substring(l + 1), false);
    }

    public static java.lang.Enum getByEnumConst(String enumType, String constField) {
        return ClassUtils.getByEnumConst(enumType, constField, false);
    }

    public static java.lang.Enum getByEnumConst(String enumType, String constField, boolean nullOnNotFound) {
        Field[] flds;
        ClassMeta cm = ClassUtils.getMeta(enumType);
        Optional<java.lang.Enum> en = cm.enumFields.get(constField);
        if (en != null) {
            if (en.isPresent()) {
                return en.get();
            }
            if (nullOnNotFound) {
                return null;
            }
            throw cm.enumUnknowns.get(constField);
        }
        for (Field f : flds = cm.getTypeClass().getDeclaredFields()) {
            if (!java.lang.Enum.class.isAssignableFrom(f.getType())) continue;
            Object v = java.lang.Enum.valueOf(f.getType(), f.getName());
            cm.enumFields.put(f.getName(), Optional.of(v));
            Enum v2 = (Enum)v;
            if (!v2.getLexicalValue().isPresent()) continue;
            cm.enumFields.put(v2.getLexicalValue().get(), Optional.of(v));
        }
        Optional<java.lang.Enum> c = cm.enumFields.get(constField);
        if (c == null) {
            cm.enumFields.put(constField, Optional.empty());
            AlfaRuntimeException excp = new AlfaRuntimeException(ConstraintType.InvalidConstant, "Invalid value '" + constField + "' for type '" + enumType + "'");
            cm.enumUnknowns.put(constField, excp);
            if (nullOnNotFound) {
                return null;
            }
            throw excp;
        }
        return c.get();
    }

    private static Class forName(String n) throws ClassNotFoundException {
        if (classLoader.get() == null) {
            classLoader.set(Thread.currentThread().getContextClassLoader());
        }
        return ((ClassLoader)classLoader.get()).loadClass(n);
    }

    public static boolean isDefined(String type) {
        Boolean existing = definedClasses.get(type);
        if (existing != null) {
            return existing;
        }
        try {
            ClassUtils.forName(type);
            definedClasses.put(type, true);
            return true;
        }
        catch (ClassNotFoundException e) {
            definedClasses.put(type, false);
            return false;
        }
    }

    public static ClassMeta getMeta(String type) {
        ClassMeta existing = classCache.get(type);
        if (existing != null) {
            return existing;
        }
        try {
            Class clz = ClassUtils.forName(type);
            ClassMeta cm = new ClassMeta();
            cm.typeClass = clz;
            if (!(Service.class.isAssignableFrom(clz) || Library.class.isAssignableFrom(clz) || Testcase.class.isAssignableFrom(clz))) {
                String[] split = type.split("\\.");
                Class descclz = ClassUtils.forName(type + "$" + split[split.length - 1] + "Descriptor");
                cm.model = (TypeDescriptor)descclz.getDeclaredField("INSTANCE").get(null);
                if (cm.model == null) {
                    throw new AlfaRuntimeException("Failed to load model for " + type);
                }
            }
            classCache.put(type, cm);
            return cm;
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    public static <T> T getDeclaredFieldValue(Object obj, String fieldName) {
        try {
            return (T)ClassUtils.getField(obj, fieldName).get(obj);
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    public static void setDeclaredFieldValue(Object obj, String fieldName, Object o) {
        try {
            ClassUtils.getField(obj, fieldName).set(obj, o);
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    public static Field getField(Object obj, String fieldName) {
        Class<?> cls = obj.getClass();
        String idx = cls.getTypeName() + ":" + fieldName;
        Field f = classFieldMap.get(idx);
        if (f == null) {
            f = ClassUtils.getDeclaredField(cls, fieldName);
            classFieldMap.put(idx, f);
        }
        if (f == null) {
            throw new AlfaRuntimeException(ConstraintType.UnknownField, "Failed to find field " + fieldName + " in " + obj.getClass().getName());
        }
        return f;
    }

    private static Field getDeclaredField(Class<?> cls, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException nsf) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getDeclaredField(cls.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    public static class ClassMeta {
        private Map<String, Optional<java.lang.Enum>> enumFields = new HashMap<String, Optional<java.lang.Enum>>();
        private Map<String, AlfaRuntimeException> enumUnknowns = new HashMap<String, AlfaRuntimeException>();
        private Class<?> typeClass;
        private TypeDescriptor model;

        private ClassMeta() {
        }

        public Builder getNewBuilder(IBuilderConfig cc) {
            try {
                return this.model.builder(cc);
            }
            catch (Exception e) {
                if (e instanceof AlfaRuntimeException) {
                    throw e;
                }
                throw new AlfaRuntimeException(ConstraintType.Unknown, "Failed to create newBuilder. ", e);
            }
        }

        public Class<?> getTypeClass() {
            return this.typeClass;
        }

        public TypeDescriptor getModel() {
            return this.model;
        }

        public boolean hasBuilderClass() {
            return this.model != null && this.model.hasBuilder();
        }

        public String toString() {
            return "ClassMeta:" + this.typeClass.getName() + ";";
        }

        public boolean isTypeAssignable(ClassMeta other) {
            return this.typeClass.isAssignableFrom(other.typeClass);
        }

        public void assertCompatible(ClassMeta other) {
            if (!this.typeClass.isAssignableFrom(other.typeClass)) {
                throw new AlfaRuntimeException("Types incompatible - " + this.typeClass.getName() + " and " + other.typeClass.getName());
            }
        }
    }
}

