/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.EntityBuilder;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.NoOpDataConsumer;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.OptSetChecker;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import schemarise.alfa.runtime.model.CompressedDataType;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.EncryptedDataType;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryDataType;

class ToBuilderCreator
extends NoOpDataConsumer {
    private final IBuilderConfig codecConfig;
    private Stack<Object> valueStack = new Stack();
    private Stack<Builder> buildersStack = new Stack();
    private Builder lastBuilder;

    public ToBuilderCreator(IBuilderConfig cc, AlfaObject so) {
        this.codecConfig = cc;
        this.consume(so);
    }

    @Override
    public <T> void consume(CompressedDataType dt, Compressed v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.valueStack.push(v);
    }

    @Override
    public <T> void consume(EncryptedDataType dt, Encrypted<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.valueStack.push(v);
    }

    @Override
    public <T> void consume(StreamDataType dt, List<T> f1, BiConsumer<T, DataConsumer> consumer) {
        super.consume(dt, f1, consumer);
    }

    @Override
    public <T> void consume(FutureDataType dt, Future<T> f1, BiConsumer<T, DataConsumer> consumer) {
        super.consume(dt, f1, consumer);
    }

    @Override
    public <T> void consume(TabularDataType dt, ITable f1, BiConsumer<T, DataConsumer> consumer) {
        super.consume(dt, f1, consumer);
    }

    @Override
    public <T> void consume(TryDataType dt, Try<T> v, BiConsumer<T, DataConsumer> c) {
        super.consume(dt, v, c);
    }

    @Override
    public <L, R> void consume(EitherDataType dt, Either<L, R> v, BiConsumer<L, DataConsumer> leftConsumer, BiConsumer<R, DataConsumer> rightConsumer) {
        super.consume(dt, v, leftConsumer, rightConsumer);
    }

    public Builder newBuilder() {
        return this.lastBuilder;
    }

    @Override
    public void consume(ScalarDataType dt, int v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, String v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, double v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, float v) {
        this.valueStack.push(Float.valueOf(v));
    }

    @Override
    public void consume(ScalarDataType dt, short v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, long v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, byte v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, byte[] v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, char v) {
        this.valueStack.push(Character.valueOf(v));
    }

    @Override
    public void consume(ScalarDataType dt, boolean v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, BigDecimal v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, LocalDate v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, ZonedDateTime v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, LocalDateTime v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, LocalTime v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, Duration v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, NormalizedPeriod v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, UUID v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(ScalarDataType dt, URI v) {
        this.valueStack.push(v);
    }

    @Override
    public <K, V> void consume(MapDataType dt, Map<K, V> map, BiConsumer<K, DataConsumer> keyConsumer, BiConsumer<V, DataConsumer> valueConsumer) {
        LinkedHashMap m = new LinkedHashMap(map.size());
        map.forEach((k, v) -> {
            keyConsumer.accept(k, this);
            Object nk = this.valueStack.pop();
            int x = this.valueStack.size();
            valueConsumer.accept(v, this);
            int y = this.valueStack.size();
            Object nv = this.valueStack.pop();
            m.put(nk, nv);
        });
        this.valueStack.push(m);
    }

    @Override
    public <T> void consume(SetDataType dt, Set<T> set, BiConsumer<T, DataConsumer> elementConsumer) {
        LinkedHashSet s = new LinkedHashSet(set.size());
        set.forEach(e -> {
            elementConsumer.accept(e, this);
            s.add(this.valueStack.pop());
        });
        this.valueStack.push(s);
    }

    @Override
    public <T> void consume(ListDataType dt, List<T> list, BiConsumer<T, DataConsumer> elementConsumer) {
        ArrayList s = new ArrayList(list.size());
        list.forEach(e -> {
            elementConsumer.accept(e, this);
            s.add(this.valueStack.pop());
        });
        this.valueStack.push(s);
    }

    @Override
    public <T> void consume(OptionalDataType dt, Optional<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        if (v.isPresent()) {
            elementConsumer.accept(v.get(), this);
            this.valueStack.push(Optional.of(this.valueStack.pop()));
        } else {
            this.valueStack.push(Optional.empty());
        }
    }

    @Override
    public void consume(ScalarDataType dt, UnionUntypedCase v) {
        this.valueStack.push(v);
    }

    @Override
    public void consume(IDataType dt, AlfaObject v, Map<String, BiConsumer> templatedFieldConsumer) {
        Builder b;
        if (!v.descriptor().hasBuilder()) {
            this.valueStack.push(v);
            return;
        }
        this.buildersStack.push(v.descriptor().builder(this.codecConfig));
        if (v instanceof Union) {
            Union u = (Union)v;
            String c = u.caseName();
            BiConsumer sup = templatedFieldConsumer.get(c);
            if (sup != null) {
                Object cv = u.caseValue();
                sup.accept(cv, this);
            } else {
                Optional o = v.descriptor().getFieldSupplier(c);
                if (o.isPresent()) {
                    o.get().accept(v, this);
                } else {
                    throw new AlfaRuntimeException("Not consuming field");
                }
            }
            this.buildersStack.peek().modify(c, this.valueStack.pop());
        } else {
            Entity ent;
            Optional<? extends Key> k;
            if (v instanceof Entity && (k = (ent = (Entity)v).get$key()).isPresent()) {
                this.consume(k.get());
                ((EntityBuilder)((Object)this.buildersStack.peek())).set$key(this.valueStack.pop());
            }
            OptSetChecker checker = new OptSetChecker();
            for (String fn : v.descriptor().getAllFieldsMeta().keySet()) {
                BiConsumer<AlfaObject, DataConsumer> sup = v.descriptor().getFieldSupplier(fn).get();
                if (v.descriptor().getAllFieldsMeta().get(fn).getDataType() instanceof OptionalDataType) {
                    sup.accept(v, checker);
                    if (!checker.isSet()) continue;
                }
                sup.accept(v, this);
                this.buildersStack.peek().modify(fn, this.valueStack.pop());
            }
        }
        this.lastBuilder = b = this.buildersStack.pop();
        if (this.buildersStack.size() > 0) {
            this.valueStack.push(b.build());
        }
    }
}

