/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.CustomEncodedType;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.codec.Converters;
import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime_int.JsonReader;
import com.schemarise.alfa.runtime_int.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

abstract class DefaultCustomEncodedType<T>
implements CustomEncodedType<T> {
    private Function<DataSupplier, T> supplier;
    private BiConsumer<T, DataConsumer> consumer;
    protected byte[] encodedBytes;
    public static TypeDescriptor model = new TypeDescriptor(){

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return null;
        }

        @Override
        public Set<String> getAllDescendants() {
            return null;
        }

        @Override
        public List<String> getFieldAssignableToTypeName(String toFullyQualifiedName) {
            return null;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return Collections.emptyMap();
        }

        public Optional<Function<AlfaObject, Supplier>> getFieldSupplier(String fieldName) {
            return null;
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return null;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public <T extends AlfaObject> Map<String, FieldMeta<T>> getAllFieldsMeta() {
            return null;
        }

        @Override
        public List<String> getAllFieldNames() {
            return Collections.emptyList();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return null;
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return true;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public Optional<String> getFieldContainingNestedUnionField(String name) {
            return Optional.empty();
        }
    };

    protected DefaultCustomEncodedType(Function<DataSupplier, T> c, byte[] encodedBytes) {
        this.encodedBytes = encodedBytes;
        this.supplier = c;
    }

    protected DefaultCustomEncodedType(Converters.SupplierConsumer<T> conv, IBuilderConfig builderConfig, T o) {
        this.supplier = conv.getSupplier();
        this.consumer = conv.getConsumer();
        byte[] b = this.toBytes(builderConfig, o);
        this.encodedBytes = this.encode(builderConfig, b);
    }

    @Override
    public byte[] getEncodedBytes() {
        return this.encodedBytes;
    }

    protected abstract byte[] encode(IBuilderConfig var1, byte[] var2);

    protected abstract byte[] decode(IBuilderConfig var1, byte[] var2);

    private T toObject(IBuilderConfig cc, byte[] b) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(b);
            JsonCodecConfig jwc = JsonCodecConfig.builder().setRuntimeContext(cc.getRuntimeContext()).build();
            DataSupplier w = JsonReader.getInstance().reader(jwc, stream);
            T obj = this.supplier.apply(w);
            return obj;
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    private byte[] toBytes(IBuilderConfig cc, T under) {
        try {
            JsonCodecConfig jwc = JsonCodecConfig.builder().setRuntimeContext(cc.getRuntimeContext()).build();
            DataConsumer w = JsonWriter.getInstance().writer(jwc);
            this.consumer.accept(under, w);
            ByteArrayOutputStream buf = (ByteArrayOutputStream)w.closeAndGetBuffer();
            return buf.toByteArray();
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    @Override
    public T getValue(IBuilderConfig builderConfig) {
        byte[] decoded = this.decode(builderConfig, this.encodedBytes);
        return this.toObject(builderConfig, decoded);
    }

    public String toString() {
        return "\"" + Base64.getEncoder().encodeToString(this.encodedBytes) + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCustomEncodedType that = (DefaultCustomEncodedType)o;
        return Arrays.equals(this.encodedBytes, that.encodedBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedBytes);
    }

    @Override
    public TypeDescriptor descriptor() {
        return model;
    }
}

