/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.PersistenceSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import schemarise.alfa.runtime.model.Expression;

public class DefaultPersistenceSupport
implements PersistenceSupport {
    private Path _localDbDir;

    @Override
    public <T extends AlfaObject> List<T> query(Optional<AlfaObject> currentObject, String entityName, Expression.CaseLambdaExpr condition, Map<String, Integer> sort, int limit, Optional<String> storeName) {
        throw new AlfaRuntimeException("Query for " + entityName + " not implemented in default. Supply custom  com.schemarise.alfa.runtime.RuntimeContext implementation.");
    }

    @Override
    public <T extends AlfaObject> Boolean keyExists(String entityName, Key ok, Optional<String> storeName) {
        Optional<T> l = this.lookup(entityName, ok, Optional.empty());
        return l.isPresent();
    }

    @Override
    public <T extends AlfaObject> boolean exists(String entityName, Expression.CaseLambdaExpr condition, Optional<String> storeName) {
        throw new AlfaRuntimeException("Exists for " + entityName + " not implemented in default. Supply custom  com.schemarise.alfa.runtime.RuntimeContext implementation.");
    }

    @Override
    public <T extends AlfaObject> Optional<T> lookup(String entityName, Key ok, Optional<String> storeName) {
        Path entityPath = this.entityPath(this.localDbDir(), entityName);
        String ks = this.keyToDir(ok);
        Path keyedFile = entityPath.resolve(ks + ".json");
        try {
            if (Files.exists(keyedFile, new LinkOption[0])) {
                List l = Files.lines(keyedFile).collect(Collectors.toList());
                Object obj = Alfa.jsonCodec().fromJsonString(String.join((CharSequence)"", l));
                return Optional.of(obj);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Entity> void save(T entity, Optional<String> storeName) {
        String name = entity.descriptor().getUdtDataType().getFullyQualifiedName();
        Optional<? extends Key> k = entity.get$key();
        try {
            String json = Alfa.jsonCodec().toFormattedJson(entity);
            if (k.isPresent()) {
                Path entityPath = this.entityPath(this.localDbDir(), name);
                String ks = this.keyToDir(k.get());
                Path keyedFile = entityPath.resolve(ks + ".json");
                Files.write(keyedFile, json.getBytes(), new OpenOption[0]);
            } else {
                Path entityPath = this.localDbDir().resolve(name + ".json");
                Files.write(entityPath, json.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path localDbDir() {
        if (this._localDbDir == null) {
            try {
                this._localDbDir = Files.createTempDirectory("alfa-rt-local-db-", new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.walk(this._localDbDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
        }
        return this._localDbDir;
    }

    private String keyToDir(Key k) {
        List l = k.descriptor().getAllFieldNames().stream().map(fn -> k.get((String)fn).toString()).collect(Collectors.toList());
        return String.join((CharSequence)"-", l);
    }

    private Path entityPath(Path p, String ename) {
        Path ep = p.resolve(ename);
        try {
            Files.createDirectories(ep, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ep;
    }
}

