/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.IBuiltinFunctions;
import com.schemarise.alfa.runtime.IDecisionExecTableRow;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.MessagingSupport;
import com.schemarise.alfa.runtime.PersistenceSupport;
import com.schemarise.alfa.runtime.RuntimeContext;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.Converters;
import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime.utils.AlfaUtils;
import com.schemarise.alfa.runtime.utils.BuiltinFunctionsImpl;
import com.schemarise.alfa.runtime_int.AlfaRandomGenerator;
import com.schemarise.alfa.runtime_int.DecisionExecTable;
import com.schemarise.alfa.runtime_int.DefaultCompressed;
import com.schemarise.alfa.runtime_int.DefaultEncrypted;
import com.schemarise.alfa.runtime_int.DefaultRuntimeContext;
import com.schemarise.alfa.runtime_int.JsonDataConsumer;
import com.schemarise.alfa.runtime_int.JsonDataSupplier;
import com.schemarise.alfa.runtime_int.JsonReader;
import com.schemarise.alfa.runtime_int.JsonWriter;
import com.schemarise.alfa.runtime_int.SizeEstimateGenerator;
import com.schemarise.alfa.runtime_int.table.TableCodecImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.DecisionTable__HitPolicy;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;

public final class IntImpl {
    public static IBuiltinFunctions createBuiltinFunctions(RuntimeContext rc) {
        return new BuiltinFunctionsImpl(rc);
    }

    public static RuntimeContext defaultRuntimeContext() {
        return DefaultRuntimeContext.getInstance();
    }

    public static RuntimeContext createRuntimeContext(PersistenceSupport ps, MessagingSupport ms) {
        return new DefaultRuntimeContext(ps, ms);
    }

    public static SizeEstimatorIfc sizeEstimateGenerator(Set<String> strings, AlfaObject so) {
        return new SizeEstimateGenerator(strings, so);
    }

    public static SizeEstimatorIfc sizeEstimateGenerator(AlfaObject so) {
        return new SizeEstimateGenerator(so);
    }

    public static <T> Encrypted<T> defaultEncryptedFromValue(Function<DataSupplier, T> encryptedConsumer, byte[] bin) {
        return DefaultEncrypted.fromValue(encryptedConsumer, bin);
    }

    public static <T> Encrypted<T> defaultEncryptedFromValue(Converters.SupplierConsumer<T> convertor, IBuilderConfig builderConfig, T unencodedObject) {
        return DefaultEncrypted.fromValue(convertor, builderConfig, unencodedObject);
    }

    public static <T> Compressed defaultCompressedFromValue(Function<DataSupplier, T> compressedConsumer, byte[] bin) {
        return DefaultCompressed.fromValue(compressedConsumer, bin);
    }

    public static <T> Compressed defaultCompressedFromValue(Converters.SupplierConsumer<T> converter, IBuilderConfig builderConfig, T unencodedObject) {
        return DefaultCompressed.fromValue(converter, builderConfig, unencodedObject);
    }

    public static AlfaRandomGeneratorIfc alfaRandomGenerator(IBuilderConfig c, List<String> allTypes) {
        return new AlfaRandomGenerator(c, allTypes);
    }

    public static DataSupplier jsonDataSupplier(JsonCodecConfig cc, JsonParser jParser) {
        return new JsonDataSupplier(cc, jParser);
    }

    public static DataConsumer jsonDataConsumer(JsonCodecConfig wc, JsonGenerator jGenerator, OutputStream stream) {
        return new JsonDataConsumer(wc, jGenerator, stream);
    }

    public static JsonWriterIfc getJsonWriterInstance() {
        return JsonWriter.getInstance();
    }

    public static TableCodecIfc getTableCodecInstance() {
        return TableCodecImpl.getInstance();
    }

    public static JsonReaderIfc getJsonReaderInstance() {
        return JsonReader.getInstance();
    }

    public static <T> Try<List<T>> getDecisionTableResults(List<Object> inputs, DecisionTable__HitPolicy hp, List<IDecisionExecTableRow> rules) {
        DecisionExecTable dt = new DecisionExecTable(inputs, hp, rules);
        List output = dt.execute();
        if (output.size() > 0) {
            return AlfaUtils.createTryValue(output);
        }
        return AlfaUtils.createTryFailure("Decision table not satisfied");
    }

    public static <T> Try<T> getDecisionTableResult(List<Object> inputs, DecisionTable__HitPolicy hp, List<IDecisionExecTableRow> rules) {
        DecisionExecTable dt = new DecisionExecTable(inputs, hp, rules);
        List output = dt.execute();
        if (output.size() == 1 && hp == DecisionTable__HitPolicy.unique) {
            return AlfaUtils.createTryValue(output.get(0));
        }
        if (output.size() >= 1 && hp == DecisionTable__HitPolicy.first) {
            return AlfaUtils.createTryValue(output.get(0));
        }
        if (output.size() >= 1 && hp == DecisionTable__HitPolicy.anyof) {
            return AlfaUtils.createTryValue(output.get(0));
        }
        if (output.size() >= 1 && hp == DecisionTable__HitPolicy.all) {
            return AlfaUtils.createTryValue(output);
        }
        return AlfaUtils.createTryFailure("Decision table not satisfied: " + String.valueOf(hp) + ". Result count: " + output.size());
    }

    public static interface TableCodecIfc {
        public ITable toTable(Collection<? extends AlfaObject> var1);

        public ITable toTable(AlfaObject var1);

        public <T extends AlfaObject> Stream<T> importRowBasedObjects(CodecConfig var1, String var2, Optional<List<String>> var3, Stream<List<Object>> var4, Map<String, Function<Object, Object>> var5);

        public <T extends AlfaObject> T importRowBasedObject(CodecConfig var1, String var2, Optional<List<String>> var3, List<Object> var4, String var5, Map<String, Function<Object, Object>> var6);
    }

    public static interface SizeEstimatorIfc {
        public void consume(UdtDataType var1, AlfaObject var2);

        public long getEstimatedSize();
    }

    public static interface AlfaRandomGeneratorIfc {
        public boolean randomizable(String var1);

        public <T extends AlfaObject> T random(String var1);

        public <T extends AlfaObject> T randomWithValues(String var1, Map<String, Object> var2);

        public IBuilderConfig codecConfig();
    }

    public static interface JsonReaderIfc {
        public <T extends AlfaObject> T read(String var1) throws IOException;

        public <T extends AlfaObject> T read(JsonCodecConfig var1, String var2) throws IOException;

        public DataSupplier reader(JsonCodecConfig var1, InputStream var2) throws IOException;

        public <T extends AlfaObject> T read(JsonCodecConfig var1, InputStream var2) throws IOException;

        public <T extends AlfaObject> T read(JsonCodecConfig var1, JsonParser var2) throws IOException;

        public <T extends AlfaObject> Stream<Either<T, ValidationAlert.ValidationAlertBuilder>> readToStream(JsonCodecConfig var1, InputStream var2) throws IOException;
    }

    public static interface JsonWriterIfc {
        public OutputStream write(JsonCodecConfig var1, AlfaObject var2) throws IOException;

        public void write(JsonCodecConfig var1, AlfaObject var2, OutputStream var3) throws IOException;

        public String asFormattedJson(AlfaObject var1) throws IOException;

        public String asFormattedJson(JsonCodecConfig var1, AlfaObject var2) throws IOException;
    }
}

