/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.fasterxml.jackson.core.JsonGenerator;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import java.io.IOException;
import java.math.BigDecimal;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

final class JsonGeneratorWrapper {
    private final JsonGenerator jGenerator;

    public JsonGeneratorWrapper(JsonGenerator jGenerator) {
        this.jGenerator = jGenerator;
    }

    public void writeStartObject() {
        try {
            this.jGenerator.writeStartObject();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.jGenerator.close();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeStringField(String s, String fullyQualifiedName) {
        try {
            this.jGenerator.writeStringField(s, fullyQualifiedName);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeFieldName(String name) {
        try {
            this.jGenerator.writeFieldName(name);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeEndObject() {
        try {
            this.jGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeNumber(int v) {
        try {
            this.jGenerator.writeNumber(v);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeString(String v) {
        try {
            this.jGenerator.writeString(v);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeBinary(byte[] bytes) {
        try {
            this.jGenerator.writeBinary(bytes);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeNumber(BigDecimal v) {
        try {
            this.jGenerator.writeNumber(v);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeBoolean(boolean v) {
        try {
            this.jGenerator.writeBoolean(v);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeNumber(long v) {
        try {
            this.jGenerator.writeNumber(v);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeNumber(double v) {
        try {
            this.jGenerator.writeNumber(v);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeNull() {
        try {
            this.jGenerator.writeNull();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeStartArray() {
        try {
            this.jGenerator.writeStartArray();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public void writeEndArray() {
        try {
            this.jGenerator.writeEndArray();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }
}

