/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.asserts;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum ConstraintType implements Enum
{
    MandatoryFieldNotSet("MandatoryFieldNotSet", Optional.empty()),
    OutsidePermittedRange("OutsidePermittedRange", Optional.empty()),
    InvalidPattern("InvalidPattern", Optional.empty()),
    InvalidConstant("InvalidConstant", Optional.empty()),
    Duplicate("Duplicate", Optional.empty()),
    InvalidTypeForField("InvalidTypeForField", Optional.empty()),
    UnknownField("UnknownField", Optional.empty()),
    InvalidDecimalScale("InvalidDecimalScale", Optional.empty()),
    InvalidDecimalPrecision("InvalidDecimalPrecision", Optional.empty()),
    DataFormatError("DataFormatError", Optional.empty()),
    UserDefinedAssert("UserDefinedAssert", Optional.empty()),
    Unknown("Unknown", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, ConstraintType> mappings;

    private ConstraintType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static ConstraintType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, ConstraintType> m = new HashMap<String, ConstraintType>();
            for (ConstraintType c : ConstraintType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return ConstraintTypeDescriptor.INSTANCE;
    }

    public static final class ConstraintTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.asserts.ConstraintType";
        public static ConstraintTypeDescriptor INSTANCE = new ConstraintTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_MANDATORYFIELDNOTSET = 0;
        public static final String FIELD_MANDATORYFIELDNOTSET = "MandatoryFieldNotSet";
        public static final short FIELD_ID_OUTSIDEPERMITTEDRANGE = 1;
        public static final String FIELD_OUTSIDEPERMITTEDRANGE = "OutsidePermittedRange";
        public static final short FIELD_ID_INVALIDPATTERN = 2;
        public static final String FIELD_INVALIDPATTERN = "InvalidPattern";
        public static final short FIELD_ID_INVALIDCONSTANT = 3;
        public static final String FIELD_INVALIDCONSTANT = "InvalidConstant";
        public static final short FIELD_ID_DUPLICATE = 4;
        public static final String FIELD_DUPLICATE = "Duplicate";
        public static final short FIELD_ID_INVALIDTYPEFORFIELD = 5;
        public static final String FIELD_INVALIDTYPEFORFIELD = "InvalidTypeForField";
        public static final short FIELD_ID_UNKNOWNFIELD = 6;
        public static final String FIELD_UNKNOWNFIELD = "UnknownField";
        public static final short FIELD_ID_INVALIDDECIMALSCALE = 7;
        public static final String FIELD_INVALIDDECIMALSCALE = "InvalidDecimalScale";
        public static final short FIELD_ID_INVALIDDECIMALPRECISION = 8;
        public static final String FIELD_INVALIDDECIMALPRECISION = "InvalidDecimalPrecision";
        public static final short FIELD_ID_DATAFORMATERROR = 9;
        public static final String FIELD_DATAFORMATERROR = "DataFormatError";
        public static final short FIELD_ID_USERDEFINEDASSERT = 10;
        public static final String FIELD_USERDEFINEDASSERT = "UserDefinedAssert";
        public static final short FIELD_ID_UNKNOWN = 11;
        public static final String FIELD_UNKNOWN = "Unknown";
        private ScalarDataType _mandatoryFieldNotSetType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _outsidePermittedRangeType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _invalidPatternType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _invalidConstantType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _duplicateType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _invalidTypeForFieldType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _unknownFieldType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _invalidDecimalScaleType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _invalidDecimalPrecisionType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _dataFormatErrorType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _userDefinedAssertType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _unknownType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta mandatoryFieldNotSetMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._mandatoryFieldNotSetType, "MandatoryFieldNotSet", Optional.empty());
        public FieldMeta outsidePermittedRangeMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._outsidePermittedRangeType, "OutsidePermittedRange", Optional.empty());
        public FieldMeta invalidPatternMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._invalidPatternType, "InvalidPattern", Optional.empty());
        public FieldMeta invalidConstantMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._invalidConstantType, "InvalidConstant", Optional.empty());
        public FieldMeta duplicateMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._duplicateType, "Duplicate", Optional.empty());
        public FieldMeta invalidTypeForFieldMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._invalidTypeForFieldType, "InvalidTypeForField", Optional.empty());
        public FieldMeta unknownFieldMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._unknownFieldType, "UnknownField", Optional.empty());
        public FieldMeta invalidDecimalScaleMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._invalidDecimalScaleType, "InvalidDecimalScale", Optional.empty());
        public FieldMeta invalidDecimalPrecisionMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._invalidDecimalPrecisionType, "InvalidDecimalPrecision", Optional.empty());
        public FieldMeta dataFormatErrorMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._dataFormatErrorType, "DataFormatError", Optional.empty());
        public FieldMeta userDefinedAssertMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._userDefinedAssertType, "UserDefinedAssert", Optional.empty());
        public FieldMeta unknownMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._unknownType, "Unknown", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<ConstraintType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(ConstraintTypeDescriptor.FIELD_MANDATORYFIELDNOTSET, mandatoryFieldNotSetMeta);
                this.put(ConstraintTypeDescriptor.FIELD_OUTSIDEPERMITTEDRANGE, outsidePermittedRangeMeta);
                this.put(ConstraintTypeDescriptor.FIELD_INVALIDPATTERN, invalidPatternMeta);
                this.put(ConstraintTypeDescriptor.FIELD_INVALIDCONSTANT, invalidConstantMeta);
                this.put(ConstraintTypeDescriptor.FIELD_DUPLICATE, duplicateMeta);
                this.put(ConstraintTypeDescriptor.FIELD_INVALIDTYPEFORFIELD, invalidTypeForFieldMeta);
                this.put(ConstraintTypeDescriptor.FIELD_UNKNOWNFIELD, unknownFieldMeta);
                this.put(ConstraintTypeDescriptor.FIELD_INVALIDDECIMALSCALE, invalidDecimalScaleMeta);
                this.put(ConstraintTypeDescriptor.FIELD_INVALIDDECIMALPRECISION, invalidDecimalPrecisionMeta);
                this.put(ConstraintTypeDescriptor.FIELD_DATAFORMATERROR, dataFormatErrorMeta);
                this.put(ConstraintTypeDescriptor.FIELD_USERDEFINEDASSERT, userDefinedAssertMeta);
                this.put(ConstraintTypeDescriptor.FIELD_UNKNOWN, unknownMeta);
            }
        });

        public Optional<Function<ConstraintType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<ConstraintType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_MANDATORYFIELDNOTSET;
                }
                case 1: {
                    return FIELD_OUTSIDEPERMITTEDRANGE;
                }
                case 2: {
                    return FIELD_INVALIDPATTERN;
                }
                case 3: {
                    return FIELD_INVALIDCONSTANT;
                }
                case 4: {
                    return FIELD_DUPLICATE;
                }
                case 5: {
                    return FIELD_INVALIDTYPEFORFIELD;
                }
                case 6: {
                    return FIELD_UNKNOWNFIELD;
                }
                case 7: {
                    return FIELD_INVALIDDECIMALSCALE;
                }
                case 8: {
                    return FIELD_INVALIDDECIMALPRECISION;
                }
                case 9: {
                    return FIELD_DATAFORMATERROR;
                }
                case 10: {
                    return FIELD_USERDEFINEDASSERT;
                }
                case 11: {
                    return FIELD_UNKNOWN;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "bedbd588:";
        }
    }
}

