/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.asserts;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum DataQualityType implements Enum
{
    Accuracy("Accuracy", Optional.empty()),
    Completeness("Completeness", Optional.empty()),
    Conformity("Conformity", Optional.empty()),
    Consistency("Consistency", Optional.empty()),
    Coverage("Coverage", Optional.empty()),
    Integrity("Integrity", Optional.empty()),
    Provenance("Provenance", Optional.empty()),
    Timeliness("Timeliness", Optional.empty()),
    Uniqueness("Uniqueness", Optional.empty()),
    Validity("Validity", Optional.empty()),
    Unclassified("Unclassified", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, DataQualityType> mappings;

    private DataQualityType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static DataQualityType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, DataQualityType> m = new HashMap<String, DataQualityType>();
            for (DataQualityType c : DataQualityType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return DataQualityTypeDescriptor.INSTANCE;
    }

    public static final class DataQualityTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.asserts.DataQualityType";
        public static DataQualityTypeDescriptor INSTANCE = new DataQualityTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_ACCURACY = 0;
        public static final String FIELD_ACCURACY = "Accuracy";
        public static final short FIELD_ID_COMPLETENESS = 1;
        public static final String FIELD_COMPLETENESS = "Completeness";
        public static final short FIELD_ID_CONFORMITY = 2;
        public static final String FIELD_CONFORMITY = "Conformity";
        public static final short FIELD_ID_CONSISTENCY = 3;
        public static final String FIELD_CONSISTENCY = "Consistency";
        public static final short FIELD_ID_COVERAGE = 4;
        public static final String FIELD_COVERAGE = "Coverage";
        public static final short FIELD_ID_INTEGRITY = 5;
        public static final String FIELD_INTEGRITY = "Integrity";
        public static final short FIELD_ID_PROVENANCE = 6;
        public static final String FIELD_PROVENANCE = "Provenance";
        public static final short FIELD_ID_TIMELINESS = 7;
        public static final String FIELD_TIMELINESS = "Timeliness";
        public static final short FIELD_ID_UNIQUENESS = 8;
        public static final String FIELD_UNIQUENESS = "Uniqueness";
        public static final short FIELD_ID_VALIDITY = 9;
        public static final String FIELD_VALIDITY = "Validity";
        public static final short FIELD_ID_UNCLASSIFIED = 10;
        public static final String FIELD_UNCLASSIFIED = "Unclassified";
        private ScalarDataType _accuracyType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _completenessType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _conformityType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _consistencyType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _coverageType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _integrityType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _provenanceType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _timelinessType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _uniquenessType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _validityType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _unclassifiedType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta accuracyMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._accuracyType, "Accuracy", Optional.empty());
        public FieldMeta completenessMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._completenessType, "Completeness", Optional.empty());
        public FieldMeta conformityMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._conformityType, "Conformity", Optional.empty());
        public FieldMeta consistencyMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._consistencyType, "Consistency", Optional.empty());
        public FieldMeta coverageMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._coverageType, "Coverage", Optional.empty());
        public FieldMeta integrityMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._integrityType, "Integrity", Optional.empty());
        public FieldMeta provenanceMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._provenanceType, "Provenance", Optional.empty());
        public FieldMeta timelinessMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._timelinessType, "Timeliness", Optional.empty());
        public FieldMeta uniquenessMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._uniquenessType, "Uniqueness", Optional.empty());
        public FieldMeta validityMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._validityType, "Validity", Optional.empty());
        public FieldMeta unclassifiedMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._unclassifiedType, "Unclassified", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<DataQualityType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(DataQualityTypeDescriptor.FIELD_ACCURACY, accuracyMeta);
                this.put(DataQualityTypeDescriptor.FIELD_COMPLETENESS, completenessMeta);
                this.put(DataQualityTypeDescriptor.FIELD_CONFORMITY, conformityMeta);
                this.put(DataQualityTypeDescriptor.FIELD_CONSISTENCY, consistencyMeta);
                this.put(DataQualityTypeDescriptor.FIELD_COVERAGE, coverageMeta);
                this.put(DataQualityTypeDescriptor.FIELD_INTEGRITY, integrityMeta);
                this.put(DataQualityTypeDescriptor.FIELD_PROVENANCE, provenanceMeta);
                this.put(DataQualityTypeDescriptor.FIELD_TIMELINESS, timelinessMeta);
                this.put(DataQualityTypeDescriptor.FIELD_UNIQUENESS, uniquenessMeta);
                this.put(DataQualityTypeDescriptor.FIELD_VALIDITY, validityMeta);
                this.put(DataQualityTypeDescriptor.FIELD_UNCLASSIFIED, unclassifiedMeta);
            }
        });

        public Optional<Function<DataQualityType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<DataQualityType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_ACCURACY;
                }
                case 1: {
                    return FIELD_COMPLETENESS;
                }
                case 2: {
                    return FIELD_CONFORMITY;
                }
                case 3: {
                    return FIELD_CONSISTENCY;
                }
                case 4: {
                    return FIELD_COVERAGE;
                }
                case 5: {
                    return FIELD_INTEGRITY;
                }
                case 6: {
                    return FIELD_PROVENANCE;
                }
                case 7: {
                    return FIELD_TIMELINESS;
                }
                case 8: {
                    return FIELD_UNIQUENESS;
                }
                case 9: {
                    return FIELD_VALIDITY;
                }
                case 10: {
                    return FIELD_UNCLASSIFIED;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "2812750d:";
        }
    }
}

