/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.asserts;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum SeverityType implements Enum
{
    Error("Error", Optional.empty()),
    Warning("Warning", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, SeverityType> mappings;

    private SeverityType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static SeverityType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, SeverityType> m = new HashMap<String, SeverityType>();
            for (SeverityType c : SeverityType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return SeverityTypeDescriptor.INSTANCE;
    }

    public static final class SeverityTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.asserts.SeverityType";
        public static SeverityTypeDescriptor INSTANCE = new SeverityTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_ERROR = 0;
        public static final String FIELD_ERROR = "Error";
        public static final short FIELD_ID_WARNING = 1;
        public static final String FIELD_WARNING = "Warning";
        private ScalarDataType _errorType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _warningType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta errorMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._errorType, "Error", Optional.empty());
        public FieldMeta warningMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._warningType, "Warning", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<SeverityType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(SeverityTypeDescriptor.FIELD_ERROR, errorMeta);
                this.put(SeverityTypeDescriptor.FIELD_WARNING, warningMeta);
            }
        });

        public Optional<Function<SeverityType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<SeverityType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_ERROR;
                }
                case 1: {
                    return FIELD_WARNING;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "d5587b0b:";
        }
    }
}

