/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.utils.Utils;
import java.time.LocalDateTime;
import java.util.Optional;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.SeverityType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;

public class AlfaRuntimeException
extends RuntimeException {
    private final ConstraintType constraintType;
    private String appended = "";
    private Optional<String> impactedField = Optional.empty();
    private Optional<String> impactedType = Optional.empty();
    private static boolean ShowStackDump = System.getProperty("ALFA.Print.AlfaRuntimeException", "false").toLowerCase().equals("true");

    public AlfaRuntimeException(String s) {
        this(ConstraintType.Unknown, s);
    }

    public AlfaRuntimeException(ConstraintType constraintType, String s) {
        super(s);
        this.constraintType = constraintType;
        if (ShowStackDump) {
            this.printStackTrace();
        }
    }

    @Override
    public String getMessage() {
        return super.getMessage() + this.appended;
    }

    public AlfaRuntimeException(ConstraintType constraintType, String s, Throwable t) {
        super(s, t);
        this.constraintType = constraintType;
    }

    public AlfaRuntimeException(ConstraintType constraintType, Throwable t) {
        super(t);
        this.constraintType = constraintType;
    }

    public ValidationAlert.ValidationAlertBuilder toValidationAlert(String msgPrefix) {
        Object msg = this.getMessage();
        if (msgPrefix.length() > 0) {
            msg = msgPrefix + ". " + (String)msg;
        }
        return ValidationAlert.builder().setViolatedConstraint(Optional.of(this.constraintType)).setMessage((String)msg).setSeverity(SeverityType.Error).setFieldName(this.impactedField).setTypeName(this.impactedType).setDataQualityCategory(Optional.of(Utils.constraintTypeToDqType(this.constraintType))).setTimestamp(LocalDateTime.now());
    }

    public AlfaRuntimeException appendMessage(String s) {
        this.appended = s;
        return this;
    }

    public void setValidationErrorField(String name) {
        this.impactedField = this.impactedField.isPresent() ? Optional.of(name + "/" + this.impactedField.get()) : Optional.of(name);
    }

    public void setValidationErrorTypeName(String name) {
        this.impactedType = this.impactedType.isPresent() ? Optional.of(name + "/" + this.impactedType.get()) : Optional.of(name);
    }
}

