/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.AlfaUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.annotation.db.TableDef;

public interface PersistenceSupport {
    public <T extends AlfaObject> List<T> query(Optional<AlfaObject> var1, String var2, Expression.CaseLambdaExpr var3, Map<String, Integer> var4, int var5, Optional<String> var6);

    public <T extends AlfaObject> Optional<T> lookup(String var1, Key var2, Optional<String> var3);

    public <T extends Entity> void save(T var1, Optional<String> var2);

    public <T extends AlfaObject> Boolean keyExists(String var1, Key var2, Optional<String> var3);

    public <T extends AlfaObject> boolean exists(String var1, Expression.CaseLambdaExpr var2, Optional<String> var3);

    default public <T extends AlfaObject> List<T> query(Optional<AlfaObject> currentObject, String entityName, Expression.CaseLambdaExpr condition, Map<String, Integer> sort, int limit) {
        return this.query(currentObject, entityName, condition, sort, limit, Optional.empty());
    }

    default public <T extends AlfaObject> List<T> query(Optional<AlfaObject> currentObject, String entityName, Expression.CaseLambdaExpr condition, Map<String, Integer> sort, int limit, String storeName) {
        return this.query(currentObject, entityName, condition, sort, limit, Optional.of(storeName));
    }

    default public <T extends AlfaObject> Optional<T> lookup(String entityName, Key ok, String storeName) {
        return this.lookup(entityName, ok, Optional.of(storeName));
    }

    default public <T extends AlfaObject> Optional<T> lookup(String entityName, Key ok) {
        return this.lookup(entityName, ok, Optional.empty());
    }

    default public <T extends Entity> void save(T entity) {
        this.save(entity, Optional.empty());
    }

    default public <T extends Entity> void save(T entity, String storeName) {
        this.save(entity, Optional.of(storeName));
    }

    default public <T extends AlfaObject> Boolean keyExists(String entityName, Key ok, String storeName) {
        return this.keyExists(entityName, ok, Optional.of(storeName));
    }

    default public <T extends AlfaObject> Boolean keyExists(String entityName, Key ok) {
        return this.keyExists(entityName, ok, Optional.empty());
    }

    default public <T extends AlfaObject> boolean exists(String entityName, Expression.CaseLambdaExpr condition) {
        return this.exists(entityName, condition, Optional.empty());
    }

    default public <T extends AlfaObject> boolean exists(String entityName, Expression.CaseLambdaExpr condition, String storeName) {
        return this.exists(entityName, condition, Optional.of(storeName));
    }

    default public Optional<TableDef> getTableAnnotation(TypeDescriptor ao) {
        return AlfaUtils.getTableAnnotation(ao);
    }
}

