/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum ModifierType implements Enum
{
    Fragment("Fragment", Optional.empty()),
    Internal("Internal", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, ModifierType> mappings;

    private ModifierType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static ModifierType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, ModifierType> m = new HashMap<String, ModifierType>();
            for (ModifierType c : ModifierType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return ModifierTypeDescriptor.INSTANCE;
    }

    public static final class ModifierTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.ModifierType";
        public static ModifierTypeDescriptor INSTANCE = new ModifierTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_FRAGMENT = 0;
        public static final String FIELD_FRAGMENT = "Fragment";
        public static final short FIELD_ID_INTERNAL = 1;
        public static final String FIELD_INTERNAL = "Internal";
        private ScalarDataType _fragmentType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _internalType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta fragmentMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._fragmentType, "Fragment", Optional.empty());
        public FieldMeta internalMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._internalType, "Internal", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<ModifierType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(ModifierTypeDescriptor.FIELD_FRAGMENT, fragmentMeta);
                this.put(ModifierTypeDescriptor.FIELD_INTERNAL, internalMeta);
            }
        });

        public Optional<Function<ModifierType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<ModifierType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_FRAGMENT;
                }
                case 1: {
                    return FIELD_INTERNAL;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "db5c8911:";
        }
    }
}

