/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.annotation.db;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum StorageMode implements Enum
{
    Relational("Relational", Optional.empty()),
    Composite("Composite", Optional.empty()),
    JSON("JSON", Optional.empty()),
    JSONB("JSONB", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, StorageMode> mappings;

    private StorageMode(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static StorageMode fromValue(String v) {
        if (mappings == null) {
            HashMap<String, StorageMode> m = new HashMap<String, StorageMode>();
            for (StorageMode c : StorageMode.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return StorageModeDescriptor.INSTANCE;
    }

    public static final class StorageModeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.annotation.db.StorageMode";
        public static StorageModeDescriptor INSTANCE = new StorageModeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_RELATIONAL = 0;
        public static final String FIELD_RELATIONAL = "Relational";
        public static final short FIELD_ID_COMPOSITE = 1;
        public static final String FIELD_COMPOSITE = "Composite";
        public static final short FIELD_ID_JSON = 2;
        public static final String FIELD_JSON = "JSON";
        public static final short FIELD_ID_JSONB = 3;
        public static final String FIELD_JSONB = "JSONB";
        private ScalarDataType _relationalType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _compositeType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _jSONType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _jSONBType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta relationalMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._relationalType, "Relational", Optional.empty());
        public FieldMeta compositeMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._compositeType, "Composite", Optional.empty());
        public FieldMeta jSONMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._jSONType, "JSON", Optional.empty());
        public FieldMeta jSONBMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._jSONBType, "JSONB", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<StorageMode>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(StorageModeDescriptor.FIELD_RELATIONAL, relationalMeta);
                this.put(StorageModeDescriptor.FIELD_COMPOSITE, compositeMeta);
                this.put(StorageModeDescriptor.FIELD_JSON, jSONMeta);
                this.put(StorageModeDescriptor.FIELD_JSONB, jSONBMeta);
            }
        });

        public Optional<Function<StorageMode, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<StorageMode>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_RELATIONAL;
                }
                case 1: {
                    return FIELD_COMPOSITE;
                }
                case 2: {
                    return FIELD_JSON;
                }
                case 3: {
                    return FIELD_JSONB;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "691f6b3c:";
        }
    }
}

