/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.accounts.types.CreateEnvironmentRequestBodyEnvironmentType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateEnvironmentRequestBody.Builder.class)
public final class CreateEnvironmentRequestBody {
    private final CreateEnvironmentRequestBodyEnvironmentType environmentType;

    private final String name;

    private final Map<String, Object> additionalProperties;

    private CreateEnvironmentRequestBody(
            CreateEnvironmentRequestBodyEnvironmentType environmentType,
            String name,
            Map<String, Object> additionalProperties) {
        this.environmentType = environmentType;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("environment_type")
    public CreateEnvironmentRequestBodyEnvironmentType getEnvironmentType() {
        return environmentType;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateEnvironmentRequestBody && equalTo((CreateEnvironmentRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateEnvironmentRequestBody other) {
        return environmentType.equals(other.environmentType) && name.equals(other.name);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.environmentType, this.name);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EnvironmentTypeStage builder() {
        return new Builder();
    }

    public interface EnvironmentTypeStage {
        NameStage environmentType(@NotNull CreateEnvironmentRequestBodyEnvironmentType environmentType);

        Builder from(CreateEnvironmentRequestBody other);
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        CreateEnvironmentRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements EnvironmentTypeStage, NameStage, _FinalStage {
        private CreateEnvironmentRequestBodyEnvironmentType environmentType;

        private String name;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateEnvironmentRequestBody other) {
            environmentType(other.getEnvironmentType());
            name(other.getName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_type")
        public NameStage environmentType(@NotNull CreateEnvironmentRequestBodyEnvironmentType environmentType) {
            this.environmentType = Objects.requireNonNull(environmentType, "environmentType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public CreateEnvironmentRequestBody build() {
            return new CreateEnvironmentRequestBody(environmentType, name, additionalProperties);
        }
    }
}
