/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.companies.types.ListEntityTraitDefinitionsRequestEntityType;
import com.schematic.api.resources.companies.types.ListEntityTraitDefinitionsRequestTraitType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListEntityTraitDefinitionsRequest.Builder.class)
public final class ListEntityTraitDefinitionsRequest {
    private final Optional<ListEntityTraitDefinitionsRequestEntityType> entityType;

    private final Optional<String> ids;

    private final Optional<String> q;

    private final Optional<ListEntityTraitDefinitionsRequestTraitType> traitType;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListEntityTraitDefinitionsRequest(
            Optional<ListEntityTraitDefinitionsRequestEntityType> entityType,
            Optional<String> ids,
            Optional<String> q,
            Optional<ListEntityTraitDefinitionsRequestTraitType> traitType,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.entityType = entityType;
        this.ids = ids;
        this.q = q;
        this.traitType = traitType;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("entity_type")
    public Optional<ListEntityTraitDefinitionsRequestEntityType> getEntityType() {
        return entityType;
    }

    @JsonProperty("ids")
    public Optional<String> getIds() {
        return ids;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    @JsonProperty("trait_type")
    public Optional<ListEntityTraitDefinitionsRequestTraitType> getTraitType() {
        return traitType;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListEntityTraitDefinitionsRequest && equalTo((ListEntityTraitDefinitionsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEntityTraitDefinitionsRequest other) {
        return entityType.equals(other.entityType)
                && ids.equals(other.ids)
                && q.equals(other.q)
                && traitType.equals(other.traitType)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.entityType, this.ids, this.q, this.traitType, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<ListEntityTraitDefinitionsRequestEntityType> entityType = Optional.empty();

        private Optional<String> ids = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<ListEntityTraitDefinitionsRequestTraitType> traitType = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListEntityTraitDefinitionsRequest other) {
            entityType(other.getEntityType());
            ids(other.getIds());
            q(other.getQ());
            traitType(other.getTraitType());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "entity_type", nulls = Nulls.SKIP)
        public Builder entityType(Optional<ListEntityTraitDefinitionsRequestEntityType> entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder entityType(ListEntityTraitDefinitionsRequestEntityType entityType) {
            this.entityType = Optional.ofNullable(entityType);
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value = "trait_type", nulls = Nulls.SKIP)
        public Builder traitType(Optional<ListEntityTraitDefinitionsRequestTraitType> traitType) {
            this.traitType = traitType;
            return this;
        }

        public Builder traitType(ListEntityTraitDefinitionsRequestTraitType traitType) {
            this.traitType = Optional.ofNullable(traitType);
            return this;
        }

        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListEntityTraitDefinitionsRequest build() {
            return new ListEntityTraitDefinitionsRequest(
                    entityType, ids, q, traitType, limit, offset, additionalProperties);
        }
    }
}
