/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCrmDealRequestBody.Builder.class)
public final class CreateCrmDealRequestBody {
    private final Optional<String> arr;

    private final Optional<String> crmCompanyId;

    private final String crmCompanyKey;

    private final Optional<String> crmProductId;

    private final String crmType;

    private final String dealExternalId;

    private final Optional<String> dealName;

    private final Optional<String> dealStage;

    private final Optional<String> mrr;

    private final Map<String, Object> additionalProperties;

    private CreateCrmDealRequestBody(
            Optional<String> arr,
            Optional<String> crmCompanyId,
            String crmCompanyKey,
            Optional<String> crmProductId,
            String crmType,
            String dealExternalId,
            Optional<String> dealName,
            Optional<String> dealStage,
            Optional<String> mrr,
            Map<String, Object> additionalProperties) {
        this.arr = arr;
        this.crmCompanyId = crmCompanyId;
        this.crmCompanyKey = crmCompanyKey;
        this.crmProductId = crmProductId;
        this.crmType = crmType;
        this.dealExternalId = dealExternalId;
        this.dealName = dealName;
        this.dealStage = dealStage;
        this.mrr = mrr;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("arr")
    public Optional<String> getArr() {
        return arr;
    }

    @JsonProperty("crm_company_id")
    public Optional<String> getCrmCompanyId() {
        return crmCompanyId;
    }

    @JsonProperty("crm_company_key")
    public String getCrmCompanyKey() {
        return crmCompanyKey;
    }

    @JsonProperty("crm_product_id")
    public Optional<String> getCrmProductId() {
        return crmProductId;
    }

    @JsonProperty("crm_type")
    public String getCrmType() {
        return crmType;
    }

    @JsonProperty("deal_external_id")
    public String getDealExternalId() {
        return dealExternalId;
    }

    @JsonProperty("deal_name")
    public Optional<String> getDealName() {
        return dealName;
    }

    @JsonProperty("deal_stage")
    public Optional<String> getDealStage() {
        return dealStage;
    }

    @JsonProperty("mrr")
    public Optional<String> getMrr() {
        return mrr;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCrmDealRequestBody && equalTo((CreateCrmDealRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmDealRequestBody other) {
        return arr.equals(other.arr)
                && crmCompanyId.equals(other.crmCompanyId)
                && crmCompanyKey.equals(other.crmCompanyKey)
                && crmProductId.equals(other.crmProductId)
                && crmType.equals(other.crmType)
                && dealExternalId.equals(other.dealExternalId)
                && dealName.equals(other.dealName)
                && dealStage.equals(other.dealStage)
                && mrr.equals(other.mrr);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.arr,
                this.crmCompanyId,
                this.crmCompanyKey,
                this.crmProductId,
                this.crmType,
                this.dealExternalId,
                this.dealName,
                this.dealStage,
                this.mrr);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CrmCompanyKeyStage builder() {
        return new Builder();
    }

    public interface CrmCompanyKeyStage {
        CrmTypeStage crmCompanyKey(@NotNull String crmCompanyKey);

        Builder from(CreateCrmDealRequestBody other);
    }

    public interface CrmTypeStage {
        DealExternalIdStage crmType(@NotNull String crmType);
    }

    public interface DealExternalIdStage {
        _FinalStage dealExternalId(@NotNull String dealExternalId);
    }

    public interface _FinalStage {
        CreateCrmDealRequestBody build();

        _FinalStage arr(Optional<String> arr);

        _FinalStage arr(String arr);

        _FinalStage crmCompanyId(Optional<String> crmCompanyId);

        _FinalStage crmCompanyId(String crmCompanyId);

        _FinalStage crmProductId(Optional<String> crmProductId);

        _FinalStage crmProductId(String crmProductId);

        _FinalStage dealName(Optional<String> dealName);

        _FinalStage dealName(String dealName);

        _FinalStage dealStage(Optional<String> dealStage);

        _FinalStage dealStage(String dealStage);

        _FinalStage mrr(Optional<String> mrr);

        _FinalStage mrr(String mrr);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CrmCompanyKeyStage, CrmTypeStage, DealExternalIdStage, _FinalStage {
        private String crmCompanyKey;

        private String crmType;

        private String dealExternalId;

        private Optional<String> mrr = Optional.empty();

        private Optional<String> dealStage = Optional.empty();

        private Optional<String> dealName = Optional.empty();

        private Optional<String> crmProductId = Optional.empty();

        private Optional<String> crmCompanyId = Optional.empty();

        private Optional<String> arr = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCrmDealRequestBody other) {
            arr(other.getArr());
            crmCompanyId(other.getCrmCompanyId());
            crmCompanyKey(other.getCrmCompanyKey());
            crmProductId(other.getCrmProductId());
            crmType(other.getCrmType());
            dealExternalId(other.getDealExternalId());
            dealName(other.getDealName());
            dealStage(other.getDealStage());
            mrr(other.getMrr());
            return this;
        }

        @java.lang.Override
        @JsonSetter("crm_company_key")
        public CrmTypeStage crmCompanyKey(@NotNull String crmCompanyKey) {
            this.crmCompanyKey = Objects.requireNonNull(crmCompanyKey, "crmCompanyKey must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("crm_type")
        public DealExternalIdStage crmType(@NotNull String crmType) {
            this.crmType = Objects.requireNonNull(crmType, "crmType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("deal_external_id")
        public _FinalStage dealExternalId(@NotNull String dealExternalId) {
            this.dealExternalId = Objects.requireNonNull(dealExternalId, "dealExternalId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage mrr(String mrr) {
            this.mrr = Optional.ofNullable(mrr);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "mrr", nulls = Nulls.SKIP)
        public _FinalStage mrr(Optional<String> mrr) {
            this.mrr = mrr;
            return this;
        }

        @java.lang.Override
        public _FinalStage dealStage(String dealStage) {
            this.dealStage = Optional.ofNullable(dealStage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "deal_stage", nulls = Nulls.SKIP)
        public _FinalStage dealStage(Optional<String> dealStage) {
            this.dealStage = dealStage;
            return this;
        }

        @java.lang.Override
        public _FinalStage dealName(String dealName) {
            this.dealName = Optional.ofNullable(dealName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "deal_name", nulls = Nulls.SKIP)
        public _FinalStage dealName(Optional<String> dealName) {
            this.dealName = dealName;
            return this;
        }

        @java.lang.Override
        public _FinalStage crmProductId(String crmProductId) {
            this.crmProductId = Optional.ofNullable(crmProductId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "crm_product_id", nulls = Nulls.SKIP)
        public _FinalStage crmProductId(Optional<String> crmProductId) {
            this.crmProductId = crmProductId;
            return this;
        }

        @java.lang.Override
        public _FinalStage crmCompanyId(String crmCompanyId) {
            this.crmCompanyId = Optional.ofNullable(crmCompanyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "crm_company_id", nulls = Nulls.SKIP)
        public _FinalStage crmCompanyId(Optional<String> crmCompanyId) {
            this.crmCompanyId = crmCompanyId;
            return this;
        }

        @java.lang.Override
        public _FinalStage arr(String arr) {
            this.arr = Optional.ofNullable(arr);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "arr", nulls = Nulls.SKIP)
        public _FinalStage arr(Optional<String> arr) {
            this.arr = arr;
            return this;
        }

        @java.lang.Override
        public CreateCrmDealRequestBody build() {
            return new CreateCrmDealRequestBody(
                    arr,
                    crmCompanyId,
                    crmCompanyKey,
                    crmProductId,
                    crmType,
                    dealExternalId,
                    dealName,
                    dealStage,
                    mrr,
                    additionalProperties);
        }
    }
}
