/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCrmProductRequestBody.Builder.class)
public final class CreateCrmProductRequestBody {
    private final String currency;

    private final String description;

    private final String externalId;

    private final String interval;

    private final String name;

    private final String price;

    private final int quantity;

    private final String sku;

    private final Map<String, Object> additionalProperties;

    private CreateCrmProductRequestBody(
            String currency,
            String description,
            String externalId,
            String interval,
            String name,
            String price,
            int quantity,
            String sku,
            Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.description = description;
        this.externalId = externalId;
        this.interval = interval;
        this.name = name;
        this.price = price;
        this.quantity = quantity;
        this.sku = sku;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("price")
    public String getPrice() {
        return price;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("sku")
    public String getSku() {
        return sku;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCrmProductRequestBody && equalTo((CreateCrmProductRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmProductRequestBody other) {
        return currency.equals(other.currency)
                && description.equals(other.description)
                && externalId.equals(other.externalId)
                && interval.equals(other.interval)
                && name.equals(other.name)
                && price.equals(other.price)
                && quantity == other.quantity
                && sku.equals(other.sku);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.currency,
                this.description,
                this.externalId,
                this.interval,
                this.name,
                this.price,
                this.quantity,
                this.sku);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    public interface CurrencyStage {
        DescriptionStage currency(@NotNull String currency);

        Builder from(CreateCrmProductRequestBody other);
    }

    public interface DescriptionStage {
        ExternalIdStage description(@NotNull String description);
    }

    public interface ExternalIdStage {
        IntervalStage externalId(@NotNull String externalId);
    }

    public interface IntervalStage {
        NameStage interval(@NotNull String interval);
    }

    public interface NameStage {
        PriceStage name(@NotNull String name);
    }

    public interface PriceStage {
        QuantityStage price(@NotNull String price);
    }

    public interface QuantityStage {
        SkuStage quantity(int quantity);
    }

    public interface SkuStage {
        _FinalStage sku(@NotNull String sku);
    }

    public interface _FinalStage {
        CreateCrmProductRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CurrencyStage,
                    DescriptionStage,
                    ExternalIdStage,
                    IntervalStage,
                    NameStage,
                    PriceStage,
                    QuantityStage,
                    SkuStage,
                    _FinalStage {
        private String currency;

        private String description;

        private String externalId;

        private String interval;

        private String name;

        private String price;

        private int quantity;

        private String sku;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCrmProductRequestBody other) {
            currency(other.getCurrency());
            description(other.getDescription());
            externalId(other.getExternalId());
            interval(other.getInterval());
            name(other.getName());
            price(other.getPrice());
            quantity(other.getQuantity());
            sku(other.getSku());
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public DescriptionStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public ExternalIdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public IntervalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public NameStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public QuantityStage price(@NotNull String price) {
            this.price = Objects.requireNonNull(price, "price must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public SkuStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("sku")
        public _FinalStage sku(@NotNull String sku) {
            this.sku = Objects.requireNonNull(sku, "sku must not be null");
            return this;
        }

        @java.lang.Override
        public CreateCrmProductRequestBody build() {
            return new CreateCrmProductRequestBody(
                    currency, description, externalId, interval, name, price, quantity, sku, additionalProperties);
        }
    }
}
