/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingSubscriptionDiscount.Builder.class)
public final class BillingSubscriptionDiscount {
    private final String couponExternalId;

    private final Optional<String> customerFacingCode;

    private final Optional<OffsetDateTime> endedAt;

    private final String externalId;

    private final boolean isActive;

    private final Optional<String> promoCodeExternalId;

    private final OffsetDateTime startedAt;

    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionDiscount(
            String couponExternalId,
            Optional<String> customerFacingCode,
            Optional<OffsetDateTime> endedAt,
            String externalId,
            boolean isActive,
            Optional<String> promoCodeExternalId,
            OffsetDateTime startedAt,
            Map<String, Object> additionalProperties) {
        this.couponExternalId = couponExternalId;
        this.customerFacingCode = customerFacingCode;
        this.endedAt = endedAt;
        this.externalId = externalId;
        this.isActive = isActive;
        this.promoCodeExternalId = promoCodeExternalId;
        this.startedAt = startedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("coupon_external_id")
    public String getCouponExternalId() {
        return couponExternalId;
    }

    @JsonProperty("customer_facing_code")
    public Optional<String> getCustomerFacingCode() {
        return customerFacingCode;
    }

    @JsonProperty("ended_at")
    public Optional<OffsetDateTime> getEndedAt() {
        return endedAt;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("is_active")
    public boolean getIsActive() {
        return isActive;
    }

    @JsonProperty("promo_code_external_id")
    public Optional<String> getPromoCodeExternalId() {
        return promoCodeExternalId;
    }

    @JsonProperty("started_at")
    public OffsetDateTime getStartedAt() {
        return startedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingSubscriptionDiscount && equalTo((BillingSubscriptionDiscount) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionDiscount other) {
        return couponExternalId.equals(other.couponExternalId)
                && customerFacingCode.equals(other.customerFacingCode)
                && endedAt.equals(other.endedAt)
                && externalId.equals(other.externalId)
                && isActive == other.isActive
                && promoCodeExternalId.equals(other.promoCodeExternalId)
                && startedAt.equals(other.startedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.couponExternalId,
                this.customerFacingCode,
                this.endedAt,
                this.externalId,
                this.isActive,
                this.promoCodeExternalId,
                this.startedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CouponExternalIdStage builder() {
        return new Builder();
    }

    public interface CouponExternalIdStage {
        ExternalIdStage couponExternalId(@NotNull String couponExternalId);

        Builder from(BillingSubscriptionDiscount other);
    }

    public interface ExternalIdStage {
        IsActiveStage externalId(@NotNull String externalId);
    }

    public interface IsActiveStage {
        StartedAtStage isActive(boolean isActive);
    }

    public interface StartedAtStage {
        _FinalStage startedAt(@NotNull OffsetDateTime startedAt);
    }

    public interface _FinalStage {
        BillingSubscriptionDiscount build();

        _FinalStage customerFacingCode(Optional<String> customerFacingCode);

        _FinalStage customerFacingCode(String customerFacingCode);

        _FinalStage endedAt(Optional<OffsetDateTime> endedAt);

        _FinalStage endedAt(OffsetDateTime endedAt);

        _FinalStage promoCodeExternalId(Optional<String> promoCodeExternalId);

        _FinalStage promoCodeExternalId(String promoCodeExternalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CouponExternalIdStage, ExternalIdStage, IsActiveStage, StartedAtStage, _FinalStage {
        private String couponExternalId;

        private String externalId;

        private boolean isActive;

        private OffsetDateTime startedAt;

        private Optional<String> promoCodeExternalId = Optional.empty();

        private Optional<OffsetDateTime> endedAt = Optional.empty();

        private Optional<String> customerFacingCode = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingSubscriptionDiscount other) {
            couponExternalId(other.getCouponExternalId());
            customerFacingCode(other.getCustomerFacingCode());
            endedAt(other.getEndedAt());
            externalId(other.getExternalId());
            isActive(other.getIsActive());
            promoCodeExternalId(other.getPromoCodeExternalId());
            startedAt(other.getStartedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("coupon_external_id")
        public ExternalIdStage couponExternalId(@NotNull String couponExternalId) {
            this.couponExternalId = Objects.requireNonNull(couponExternalId, "couponExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public IsActiveStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_active")
        public StartedAtStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @java.lang.Override
        @JsonSetter("started_at")
        public _FinalStage startedAt(@NotNull OffsetDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage promoCodeExternalId(String promoCodeExternalId) {
            this.promoCodeExternalId = Optional.ofNullable(promoCodeExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "promo_code_external_id", nulls = Nulls.SKIP)
        public _FinalStage promoCodeExternalId(Optional<String> promoCodeExternalId) {
            this.promoCodeExternalId = promoCodeExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage endedAt(OffsetDateTime endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ended_at", nulls = Nulls.SKIP)
        public _FinalStage endedAt(Optional<OffsetDateTime> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage customerFacingCode(String customerFacingCode) {
            this.customerFacingCode = Optional.ofNullable(customerFacingCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "customer_facing_code", nulls = Nulls.SKIP)
        public _FinalStage customerFacingCode(Optional<String> customerFacingCode) {
            this.customerFacingCode = customerFacingCode;
            return this;
        }

        @java.lang.Override
        public BillingSubscriptionDiscount build() {
            return new BillingSubscriptionDiscount(
                    couponExternalId,
                    customerFacingCode,
                    endedAt,
                    externalId,
                    isActive,
                    promoCodeExternalId,
                    startedAt,
                    additionalProperties);
        }
    }
}
