/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CheckFlagRequestBody.Builder.class)
public final class CheckFlagRequestBody {
    private final Optional<Map<String, String>> company;

    private final Optional<Map<String, String>> user;

    private final Map<String, Object> additionalProperties;

    private CheckFlagRequestBody(
            Optional<Map<String, String>> company,
            Optional<Map<String, String>> user,
            Map<String, Object> additionalProperties) {
        this.company = company;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company")
    public Optional<Map<String, String>> getCompany() {
        return company;
    }

    @JsonProperty("user")
    public Optional<Map<String, String>> getUser() {
        return user;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CheckFlagRequestBody && equalTo((CheckFlagRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckFlagRequestBody other) {
        return company.equals(other.company) && user.equals(other.user);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.company, this.user);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Map<String, String>> company = Optional.empty();

        private Optional<Map<String, String>> user = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CheckFlagRequestBody other) {
            company(other.getCompany());
            user(other.getUser());
            return this;
        }

        @JsonSetter(value = "company", nulls = Nulls.SKIP)
        public Builder company(Optional<Map<String, String>> company) {
            this.company = company;
            return this;
        }

        public Builder company(Map<String, String> company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @JsonSetter(value = "user", nulls = Nulls.SKIP)
        public Builder user(Optional<Map<String, String>> user) {
            this.user = user;
            return this;
        }

        public Builder user(Map<String, String> user) {
            this.user = Optional.ofNullable(user);
            return this;
        }

        public CheckFlagRequestBody build() {
            return new CheckFlagRequestBody(company, user, additionalProperties);
        }
    }
}
