/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CheckFlagResponseData.Builder.class)
public final class CheckFlagResponseData {
    private final Optional<String> companyId;

    private final Optional<String> error;

    private final Optional<String> flagId;

    private final String reason;

    private final Optional<String> ruleId;

    private final Optional<String> userId;

    private final boolean value;

    private final Map<String, Object> additionalProperties;

    private CheckFlagResponseData(
            Optional<String> companyId,
            Optional<String> error,
            Optional<String> flagId,
            String reason,
            Optional<String> ruleId,
            Optional<String> userId,
            boolean value,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.error = error;
        this.flagId = flagId;
        this.reason = reason;
        this.ruleId = ruleId;
        this.userId = userId;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("error")
    public Optional<String> getError() {
        return error;
    }

    @JsonProperty("flag_id")
    public Optional<String> getFlagId() {
        return flagId;
    }

    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    @JsonProperty("rule_id")
    public Optional<String> getRuleId() {
        return ruleId;
    }

    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    @JsonProperty("value")
    public boolean getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CheckFlagResponseData && equalTo((CheckFlagResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckFlagResponseData other) {
        return companyId.equals(other.companyId)
                && error.equals(other.error)
                && flagId.equals(other.flagId)
                && reason.equals(other.reason)
                && ruleId.equals(other.ruleId)
                && userId.equals(other.userId)
                && value == other.value;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.error, this.flagId, this.reason, this.ruleId, this.userId, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ReasonStage builder() {
        return new Builder();
    }

    public interface ReasonStage {
        ValueStage reason(@NotNull String reason);

        Builder from(CheckFlagResponseData other);
    }

    public interface ValueStage {
        _FinalStage value(boolean value);
    }

    public interface _FinalStage {
        CheckFlagResponseData build();

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage error(Optional<String> error);

        _FinalStage error(String error);

        _FinalStage flagId(Optional<String> flagId);

        _FinalStage flagId(String flagId);

        _FinalStage ruleId(Optional<String> ruleId);

        _FinalStage ruleId(String ruleId);

        _FinalStage userId(Optional<String> userId);

        _FinalStage userId(String userId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ReasonStage, ValueStage, _FinalStage {
        private String reason;

        private boolean value;

        private Optional<String> userId = Optional.empty();

        private Optional<String> ruleId = Optional.empty();

        private Optional<String> flagId = Optional.empty();

        private Optional<String> error = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CheckFlagResponseData other) {
            companyId(other.getCompanyId());
            error(other.getError());
            flagId(other.getFlagId());
            reason(other.getReason());
            ruleId(other.getRuleId());
            userId(other.getUserId());
            value(other.getValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("reason")
        public ValueStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @java.lang.Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @java.lang.Override
        public _FinalStage ruleId(String ruleId) {
            this.ruleId = Optional.ofNullable(ruleId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rule_id", nulls = Nulls.SKIP)
        public _FinalStage ruleId(Optional<String> ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @java.lang.Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "flag_id", nulls = Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @java.lang.Override
        public _FinalStage error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "error", nulls = Nulls.SKIP)
        public _FinalStage error(Optional<String> error) {
            this.error = error;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public CheckFlagResponseData build() {
            return new CheckFlagResponseData(
                    companyId, error, flagId, reason, ruleId, userId, value, additionalProperties);
        }
    }
}
