/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CrmProductResponseData.Builder.class)
public final class CrmProductResponseData {
    private final String accountId;

    private final OffsetDateTime createdAt;

    private final String currency;

    private final String environmentId;

    private final String externalId;

    private final String name;

    private final String price;

    private final String productId;

    private final double quantity;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private CrmProductResponseData(
            String accountId,
            OffsetDateTime createdAt,
            String currency,
            String environmentId,
            String externalId,
            String name,
            String price,
            String productId,
            double quantity,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.name = name;
        this.price = price;
        this.productId = productId;
        this.quantity = quantity;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("price")
    public String getPrice() {
        return price;
    }

    @JsonProperty("product_id")
    public String getProductId() {
        return productId;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CrmProductResponseData && equalTo((CrmProductResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CrmProductResponseData other) {
        return accountId.equals(other.accountId)
                && createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && environmentId.equals(other.environmentId)
                && externalId.equals(other.externalId)
                && name.equals(other.name)
                && price.equals(other.price)
                && productId.equals(other.productId)
                && quantity == other.quantity
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.createdAt,
                this.currency,
                this.environmentId,
                this.externalId,
                this.name,
                this.price,
                this.productId,
                this.quantity,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        CreatedAtStage accountId(@NotNull String accountId);

        Builder from(CrmProductResponseData other);
    }

    public interface CreatedAtStage {
        CurrencyStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CurrencyStage {
        EnvironmentIdStage currency(@NotNull String currency);
    }

    public interface EnvironmentIdStage {
        ExternalIdStage environmentId(@NotNull String environmentId);
    }

    public interface ExternalIdStage {
        NameStage externalId(@NotNull String externalId);
    }

    public interface NameStage {
        PriceStage name(@NotNull String name);
    }

    public interface PriceStage {
        ProductIdStage price(@NotNull String price);
    }

    public interface ProductIdStage {
        QuantityStage productId(@NotNull String productId);
    }

    public interface QuantityStage {
        UpdatedAtStage quantity(double quantity);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        CrmProductResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    CreatedAtStage,
                    CurrencyStage,
                    EnvironmentIdStage,
                    ExternalIdStage,
                    NameStage,
                    PriceStage,
                    ProductIdStage,
                    QuantityStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String accountId;

        private OffsetDateTime createdAt;

        private String currency;

        private String environmentId;

        private String externalId;

        private String name;

        private String price;

        private String productId;

        private double quantity;

        private OffsetDateTime updatedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CrmProductResponseData other) {
            accountId(other.getAccountId());
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            environmentId(other.getEnvironmentId());
            externalId(other.getExternalId());
            name(other.getName());
            price(other.getPrice());
            productId(other.getProductId());
            quantity(other.getQuantity());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public EnvironmentIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public ExternalIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public NameStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public ProductIdStage price(@NotNull String price) {
            this.price = Objects.requireNonNull(price, "price must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_id")
        public QuantityStage productId(@NotNull String productId) {
            this.productId = Objects.requireNonNull(productId, "productId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public UpdatedAtStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public CrmProductResponseData build() {
            return new CrmProductResponseData(
                    accountId,
                    createdAt,
                    currency,
                    environmentId,
                    externalId,
                    name,
                    price,
                    productId,
                    quantity,
                    updatedAt,
                    additionalProperties);
        }
    }
}
