/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = EntityTraitDefinitionResponseData.Builder.class)
public final class EntityTraitDefinitionResponseData {
    private final OffsetDateTime createdAt;

    private final String displayName;

    private final String entityType;

    private final List<String> hierarchy;

    private final String id;

    private final String traitType;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private EntityTraitDefinitionResponseData(
            OffsetDateTime createdAt,
            String displayName,
            String entityType,
            List<String> hierarchy,
            String id,
            String traitType,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.displayName = displayName;
        this.entityType = entityType;
        this.hierarchy = hierarchy;
        this.id = id;
        this.traitType = traitType;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("display_name")
    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty("entity_type")
    public String getEntityType() {
        return entityType;
    }

    @JsonProperty("hierarchy")
    public List<String> getHierarchy() {
        return hierarchy;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("trait_type")
    public String getTraitType() {
        return traitType;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EntityTraitDefinitionResponseData && equalTo((EntityTraitDefinitionResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntityTraitDefinitionResponseData other) {
        return createdAt.equals(other.createdAt)
                && displayName.equals(other.displayName)
                && entityType.equals(other.entityType)
                && hierarchy.equals(other.hierarchy)
                && id.equals(other.id)
                && traitType.equals(other.traitType)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.displayName,
                this.entityType,
                this.hierarchy,
                this.id,
                this.traitType,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        DisplayNameStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(EntityTraitDefinitionResponseData other);
    }

    public interface DisplayNameStage {
        EntityTypeStage displayName(@NotNull String displayName);
    }

    public interface EntityTypeStage {
        IdStage entityType(@NotNull String entityType);
    }

    public interface IdStage {
        TraitTypeStage id(@NotNull String id);
    }

    public interface TraitTypeStage {
        UpdatedAtStage traitType(@NotNull String traitType);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        EntityTraitDefinitionResponseData build();

        _FinalStage hierarchy(List<String> hierarchy);

        _FinalStage addHierarchy(String hierarchy);

        _FinalStage addAllHierarchy(List<String> hierarchy);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    DisplayNameStage,
                    EntityTypeStage,
                    IdStage,
                    TraitTypeStage,
                    UpdatedAtStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String displayName;

        private String entityType;

        private String id;

        private String traitType;

        private OffsetDateTime updatedAt;

        private List<String> hierarchy = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(EntityTraitDefinitionResponseData other) {
            createdAt(other.getCreatedAt());
            displayName(other.getDisplayName());
            entityType(other.getEntityType());
            hierarchy(other.getHierarchy());
            id(other.getId());
            traitType(other.getTraitType());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DisplayNameStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("display_name")
        public EntityTypeStage displayName(@NotNull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entity_type")
        public IdStage entityType(@NotNull String entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public TraitTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_type")
        public UpdatedAtStage traitType(@NotNull String traitType) {
            this.traitType = Objects.requireNonNull(traitType, "traitType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllHierarchy(List<String> hierarchy) {
            this.hierarchy.addAll(hierarchy);
            return this;
        }

        @java.lang.Override
        public _FinalStage addHierarchy(String hierarchy) {
            this.hierarchy.add(hierarchy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "hierarchy", nulls = Nulls.SKIP)
        public _FinalStage hierarchy(List<String> hierarchy) {
            this.hierarchy.clear();
            this.hierarchy.addAll(hierarchy);
            return this;
        }

        @java.lang.Override
        public EntityTraitDefinitionResponseData build() {
            return new EntityTraitDefinitionResponseData(
                    createdAt, displayName, entityType, hierarchy, id, traitType, updatedAt, additionalProperties);
        }
    }
}
