/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = EventSummaryResponseData.Builder.class)
public final class EventSummaryResponseData {
    private final int companyCount;

    private final String environmentId;

    private final int eventCount;

    private final String eventSubtype;

    private final Optional<OffsetDateTime> lastSeenAt;

    private final int userCount;

    private final Map<String, Object> additionalProperties;

    private EventSummaryResponseData(
            int companyCount,
            String environmentId,
            int eventCount,
            String eventSubtype,
            Optional<OffsetDateTime> lastSeenAt,
            int userCount,
            Map<String, Object> additionalProperties) {
        this.companyCount = companyCount;
        this.environmentId = environmentId;
        this.eventCount = eventCount;
        this.eventSubtype = eventSubtype;
        this.lastSeenAt = lastSeenAt;
        this.userCount = userCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_count")
    public int getCompanyCount() {
        return companyCount;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("event_count")
    public int getEventCount() {
        return eventCount;
    }

    @JsonProperty("event_subtype")
    public String getEventSubtype() {
        return eventSubtype;
    }

    @JsonProperty("last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return lastSeenAt;
    }

    @JsonProperty("user_count")
    public int getUserCount() {
        return userCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EventSummaryResponseData && equalTo((EventSummaryResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventSummaryResponseData other) {
        return companyCount == other.companyCount
                && environmentId.equals(other.environmentId)
                && eventCount == other.eventCount
                && eventSubtype.equals(other.eventSubtype)
                && lastSeenAt.equals(other.lastSeenAt)
                && userCount == other.userCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyCount,
                this.environmentId,
                this.eventCount,
                this.eventSubtype,
                this.lastSeenAt,
                this.userCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyCountStage builder() {
        return new Builder();
    }

    public interface CompanyCountStage {
        EnvironmentIdStage companyCount(int companyCount);

        Builder from(EventSummaryResponseData other);
    }

    public interface EnvironmentIdStage {
        EventCountStage environmentId(@NotNull String environmentId);
    }

    public interface EventCountStage {
        EventSubtypeStage eventCount(int eventCount);
    }

    public interface EventSubtypeStage {
        UserCountStage eventSubtype(@NotNull String eventSubtype);
    }

    public interface UserCountStage {
        _FinalStage userCount(int userCount);
    }

    public interface _FinalStage {
        EventSummaryResponseData build();

        _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt);

        _FinalStage lastSeenAt(OffsetDateTime lastSeenAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CompanyCountStage,
                    EnvironmentIdStage,
                    EventCountStage,
                    EventSubtypeStage,
                    UserCountStage,
                    _FinalStage {
        private int companyCount;

        private String environmentId;

        private int eventCount;

        private String eventSubtype;

        private int userCount;

        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(EventSummaryResponseData other) {
            companyCount(other.getCompanyCount());
            environmentId(other.getEnvironmentId());
            eventCount(other.getEventCount());
            eventSubtype(other.getEventSubtype());
            lastSeenAt(other.getLastSeenAt());
            userCount(other.getUserCount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_count")
        public EnvironmentIdStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public EventCountStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("event_count")
        public EventSubtypeStage eventCount(int eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("event_subtype")
        public UserCountStage eventSubtype(@NotNull String eventSubtype) {
            this.eventSubtype = Objects.requireNonNull(eventSubtype, "eventSubtype must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("user_count")
        public _FinalStage userCount(int userCount) {
            this.userCount = userCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @java.lang.Override
        public EventSummaryResponseData build() {
            return new EventSummaryResponseData(
                    companyCount, environmentId, eventCount, eventSubtype, lastSeenAt, userCount, additionalProperties);
        }
    }
}
