/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FeatureCompanyUserResponseData.Builder.class)
public final class FeatureCompanyUserResponseData {
    private final boolean access;

    private final Optional<Integer> allocation;

    private final FeatureCompanyUserResponseDataAllocationType allocationType;

    private final Optional<CompanyDetailResponseData> company;

    private final String entitlementId;

    private final String entitlementType;

    private final Optional<FeatureDetailResponseData> feature;

    private final Optional<OffsetDateTime> metricResetAt;

    private final Optional<String> monthReset;

    private final Optional<String> period;

    private final Optional<PlanResponseData> plan;

    private final Optional<Integer> usage;

    private final Optional<UserResponseData> user;

    private final Map<String, Object> additionalProperties;

    private FeatureCompanyUserResponseData(
            boolean access,
            Optional<Integer> allocation,
            FeatureCompanyUserResponseDataAllocationType allocationType,
            Optional<CompanyDetailResponseData> company,
            String entitlementId,
            String entitlementType,
            Optional<FeatureDetailResponseData> feature,
            Optional<OffsetDateTime> metricResetAt,
            Optional<String> monthReset,
            Optional<String> period,
            Optional<PlanResponseData> plan,
            Optional<Integer> usage,
            Optional<UserResponseData> user,
            Map<String, Object> additionalProperties) {
        this.access = access;
        this.allocation = allocation;
        this.allocationType = allocationType;
        this.company = company;
        this.entitlementId = entitlementId;
        this.entitlementType = entitlementType;
        this.feature = feature;
        this.metricResetAt = metricResetAt;
        this.monthReset = monthReset;
        this.period = period;
        this.plan = plan;
        this.usage = usage;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Whether further usage is permitted.
     */
    @JsonProperty("access")
    public boolean getAccess() {
        return access;
    }

    /**
     * @return The maximum amount of usage that is permitted; a null value indicates that unlimited usage is permitted.
     */
    @JsonProperty("allocation")
    public Optional<Integer> getAllocation() {
        return allocation;
    }

    /**
     * @return The type of allocation that is being used.
     */
    @JsonProperty("allocation_type")
    public FeatureCompanyUserResponseDataAllocationType getAllocationType() {
        return allocationType;
    }

    @JsonProperty("company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return company;
    }

    @JsonProperty("entitlement_id")
    public String getEntitlementId() {
        return entitlementId;
    }

    @JsonProperty("entitlement_type")
    public String getEntitlementType() {
        return entitlementType;
    }

    @JsonProperty("feature")
    public Optional<FeatureDetailResponseData> getFeature() {
        return feature;
    }

    /**
     * @return The time at which the metric will resets.
     */
    @JsonProperty("metric_reset_at")
    public Optional<OffsetDateTime> getMetricResetAt() {
        return metricResetAt;
    }

    /**
     * @return If the period is current_month, when the month resets.
     */
    @JsonProperty("month_reset")
    public Optional<String> getMonthReset() {
        return monthReset;
    }

    /**
     * @return The period over which usage is measured.
     */
    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return period;
    }

    @JsonProperty("plan")
    public Optional<PlanResponseData> getPlan() {
        return plan;
    }

    /**
     * @return The amount of usage that has been consumed; a null value indicates that usage is not being measured.
     */
    @JsonProperty("usage")
    public Optional<Integer> getUsage() {
        return usage;
    }

    @JsonProperty("user")
    public Optional<UserResponseData> getUser() {
        return user;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FeatureCompanyUserResponseData && equalTo((FeatureCompanyUserResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureCompanyUserResponseData other) {
        return access == other.access
                && allocation.equals(other.allocation)
                && allocationType.equals(other.allocationType)
                && company.equals(other.company)
                && entitlementId.equals(other.entitlementId)
                && entitlementType.equals(other.entitlementType)
                && feature.equals(other.feature)
                && metricResetAt.equals(other.metricResetAt)
                && monthReset.equals(other.monthReset)
                && period.equals(other.period)
                && plan.equals(other.plan)
                && usage.equals(other.usage)
                && user.equals(other.user);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.access,
                this.allocation,
                this.allocationType,
                this.company,
                this.entitlementId,
                this.entitlementType,
                this.feature,
                this.metricResetAt,
                this.monthReset,
                this.period,
                this.plan,
                this.usage,
                this.user);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccessStage builder() {
        return new Builder();
    }

    public interface AccessStage {
        AllocationTypeStage access(boolean access);

        Builder from(FeatureCompanyUserResponseData other);
    }

    public interface AllocationTypeStage {
        EntitlementIdStage allocationType(@NotNull FeatureCompanyUserResponseDataAllocationType allocationType);
    }

    public interface EntitlementIdStage {
        EntitlementTypeStage entitlementId(@NotNull String entitlementId);
    }

    public interface EntitlementTypeStage {
        _FinalStage entitlementType(@NotNull String entitlementType);
    }

    public interface _FinalStage {
        FeatureCompanyUserResponseData build();

        _FinalStage allocation(Optional<Integer> allocation);

        _FinalStage allocation(Integer allocation);

        _FinalStage company(Optional<CompanyDetailResponseData> company);

        _FinalStage company(CompanyDetailResponseData company);

        _FinalStage feature(Optional<FeatureDetailResponseData> feature);

        _FinalStage feature(FeatureDetailResponseData feature);

        _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt);

        _FinalStage metricResetAt(OffsetDateTime metricResetAt);

        _FinalStage monthReset(Optional<String> monthReset);

        _FinalStage monthReset(String monthReset);

        _FinalStage period(Optional<String> period);

        _FinalStage period(String period);

        _FinalStage plan(Optional<PlanResponseData> plan);

        _FinalStage plan(PlanResponseData plan);

        _FinalStage usage(Optional<Integer> usage);

        _FinalStage usage(Integer usage);

        _FinalStage user(Optional<UserResponseData> user);

        _FinalStage user(UserResponseData user);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccessStage, AllocationTypeStage, EntitlementIdStage, EntitlementTypeStage, _FinalStage {
        private boolean access;

        private FeatureCompanyUserResponseDataAllocationType allocationType;

        private String entitlementId;

        private String entitlementType;

        private Optional<UserResponseData> user = Optional.empty();

        private Optional<Integer> usage = Optional.empty();

        private Optional<PlanResponseData> plan = Optional.empty();

        private Optional<String> period = Optional.empty();

        private Optional<String> monthReset = Optional.empty();

        private Optional<OffsetDateTime> metricResetAt = Optional.empty();

        private Optional<FeatureDetailResponseData> feature = Optional.empty();

        private Optional<CompanyDetailResponseData> company = Optional.empty();

        private Optional<Integer> allocation = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FeatureCompanyUserResponseData other) {
            access(other.getAccess());
            allocation(other.getAllocation());
            allocationType(other.getAllocationType());
            company(other.getCompany());
            entitlementId(other.getEntitlementId());
            entitlementType(other.getEntitlementType());
            feature(other.getFeature());
            metricResetAt(other.getMetricResetAt());
            monthReset(other.getMonthReset());
            period(other.getPeriod());
            plan(other.getPlan());
            usage(other.getUsage());
            user(other.getUser());
            return this;
        }

        /**
         * <p>Whether further usage is permitted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("access")
        public AllocationTypeStage access(boolean access) {
            this.access = access;
            return this;
        }

        /**
         * <p>The type of allocation that is being used.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("allocation_type")
        public EntitlementIdStage allocationType(@NotNull FeatureCompanyUserResponseDataAllocationType allocationType) {
            this.allocationType = Objects.requireNonNull(allocationType, "allocationType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_id")
        public EntitlementTypeStage entitlementId(@NotNull String entitlementId) {
            this.entitlementId = Objects.requireNonNull(entitlementId, "entitlementId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_type")
        public _FinalStage entitlementType(@NotNull String entitlementType) {
            this.entitlementType = Objects.requireNonNull(entitlementType, "entitlementType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage user(UserResponseData user) {
            this.user = Optional.ofNullable(user);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "user", nulls = Nulls.SKIP)
        public _FinalStage user(Optional<UserResponseData> user) {
            this.user = user;
            return this;
        }

        /**
         * <p>The amount of usage that has been consumed; a null value indicates that usage is not being measured.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage usage(Integer usage) {
            this.usage = Optional.ofNullable(usage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "usage", nulls = Nulls.SKIP)
        public _FinalStage usage(Optional<Integer> usage) {
            this.usage = usage;
            return this;
        }

        @java.lang.Override
        public _FinalStage plan(PlanResponseData plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan", nulls = Nulls.SKIP)
        public _FinalStage plan(Optional<PlanResponseData> plan) {
            this.plan = plan;
            return this;
        }

        /**
         * <p>The period over which usage is measured.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage period(String period) {
            this.period = Optional.ofNullable(period);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "period", nulls = Nulls.SKIP)
        public _FinalStage period(Optional<String> period) {
            this.period = period;
            return this;
        }

        /**
         * <p>If the period is current_month, when the month resets.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage monthReset(String monthReset) {
            this.monthReset = Optional.ofNullable(monthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "month_reset", nulls = Nulls.SKIP)
        public _FinalStage monthReset(Optional<String> monthReset) {
            this.monthReset = monthReset;
            return this;
        }

        /**
         * <p>The time at which the metric will resets.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage metricResetAt(OffsetDateTime metricResetAt) {
            this.metricResetAt = Optional.ofNullable(metricResetAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_reset_at", nulls = Nulls.SKIP)
        public _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt) {
            this.metricResetAt = metricResetAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage feature(FeatureDetailResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature", nulls = Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureDetailResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @java.lang.Override
        public _FinalStage company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company", nulls = Nulls.SKIP)
        public _FinalStage company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        /**
         * <p>The maximum amount of usage that is permitted; a null value indicates that unlimited usage is permitted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage allocation(Integer allocation) {
            this.allocation = Optional.ofNullable(allocation);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "allocation", nulls = Nulls.SKIP)
        public _FinalStage allocation(Optional<Integer> allocation) {
            this.allocation = allocation;
            return this;
        }

        @java.lang.Override
        public FeatureCompanyUserResponseData build() {
            return new FeatureCompanyUserResponseData(
                    access,
                    allocation,
                    allocationType,
                    company,
                    entitlementId,
                    entitlementType,
                    feature,
                    metricResetAt,
                    monthReset,
                    period,
                    plan,
                    usage,
                    user,
                    additionalProperties);
        }
    }
}
