/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FlagResponseData.Builder.class)
public final class FlagResponseData {
    private final OffsetDateTime createdAt;

    private final boolean defaultValue;

    private final String description;

    private final Optional<String> featureId;

    private final String flagType;

    private final String id;

    private final String key;

    private final Optional<String> maintainerId;

    private final String name;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private FlagResponseData(
            OffsetDateTime createdAt,
            boolean defaultValue,
            String description,
            Optional<String> featureId,
            String flagType,
            String id,
            String key,
            Optional<String> maintainerId,
            String name,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.defaultValue = defaultValue;
        this.description = description;
        this.featureId = featureId;
        this.flagType = flagType;
        this.id = id;
        this.key = key;
        this.maintainerId = maintainerId;
        this.name = name;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("default_value")
    public boolean getDefaultValue() {
        return defaultValue;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("feature_id")
    public Optional<String> getFeatureId() {
        return featureId;
    }

    @JsonProperty("flag_type")
    public String getFlagType() {
        return flagType;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("key")
    public String getKey() {
        return key;
    }

    @JsonProperty("maintainer_id")
    public Optional<String> getMaintainerId() {
        return maintainerId;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FlagResponseData && equalTo((FlagResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FlagResponseData other) {
        return createdAt.equals(other.createdAt)
                && defaultValue == other.defaultValue
                && description.equals(other.description)
                && featureId.equals(other.featureId)
                && flagType.equals(other.flagType)
                && id.equals(other.id)
                && key.equals(other.key)
                && maintainerId.equals(other.maintainerId)
                && name.equals(other.name)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.defaultValue,
                this.description,
                this.featureId,
                this.flagType,
                this.id,
                this.key,
                this.maintainerId,
                this.name,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        DefaultValueStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(FlagResponseData other);
    }

    public interface DefaultValueStage {
        DescriptionStage defaultValue(boolean defaultValue);
    }

    public interface DescriptionStage {
        FlagTypeStage description(@NotNull String description);
    }

    public interface FlagTypeStage {
        IdStage flagType(@NotNull String flagType);
    }

    public interface IdStage {
        KeyStage id(@NotNull String id);
    }

    public interface KeyStage {
        NameStage key(@NotNull String key);
    }

    public interface NameStage {
        UpdatedAtStage name(@NotNull String name);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        FlagResponseData build();

        _FinalStage featureId(Optional<String> featureId);

        _FinalStage featureId(String featureId);

        _FinalStage maintainerId(Optional<String> maintainerId);

        _FinalStage maintainerId(String maintainerId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    DefaultValueStage,
                    DescriptionStage,
                    FlagTypeStage,
                    IdStage,
                    KeyStage,
                    NameStage,
                    UpdatedAtStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private boolean defaultValue;

        private String description;

        private String flagType;

        private String id;

        private String key;

        private String name;

        private OffsetDateTime updatedAt;

        private Optional<String> maintainerId = Optional.empty();

        private Optional<String> featureId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FlagResponseData other) {
            createdAt(other.getCreatedAt());
            defaultValue(other.getDefaultValue());
            description(other.getDescription());
            featureId(other.getFeatureId());
            flagType(other.getFlagType());
            id(other.getId());
            key(other.getKey());
            maintainerId(other.getMaintainerId());
            name(other.getName());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DefaultValueStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("default_value")
        public DescriptionStage defaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public FlagTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("flag_type")
        public IdStage flagType(@NotNull String flagType) {
            this.flagType = Objects.requireNonNull(flagType, "flagType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("key")
        public NameStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "maintainer_id", nulls = Nulls.SKIP)
        public _FinalStage maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        @java.lang.Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature_id", nulls = Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @java.lang.Override
        public FlagResponseData build() {
            return new FlagResponseData(
                    createdAt,
                    defaultValue,
                    description,
                    featureId,
                    flagType,
                    id,
                    key,
                    maintainerId,
                    name,
                    updatedAt,
                    additionalProperties);
        }
    }
}
