/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanAudienceDetailResponseData.Builder.class)
public final class PlanAudienceDetailResponseData {
    private final List<RuleConditionGroupDetailResponseData> conditionGroups;

    private final List<RuleConditionDetailResponseData> conditions;

    private final OffsetDateTime createdAt;

    private final String environmentId;

    private final Optional<String> flagId;

    private final String id;

    private final String name;

    private final Optional<String> planId;

    private final int priority;

    private final String ruleType;

    private final OffsetDateTime updatedAt;

    private final boolean value;

    private final Map<String, Object> additionalProperties;

    private PlanAudienceDetailResponseData(
            List<RuleConditionGroupDetailResponseData> conditionGroups,
            List<RuleConditionDetailResponseData> conditions,
            OffsetDateTime createdAt,
            String environmentId,
            Optional<String> flagId,
            String id,
            String name,
            Optional<String> planId,
            int priority,
            String ruleType,
            OffsetDateTime updatedAt,
            boolean value,
            Map<String, Object> additionalProperties) {
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.flagId = flagId;
        this.id = id;
        this.name = name;
        this.planId = planId;
        this.priority = priority;
        this.ruleType = ruleType;
        this.updatedAt = updatedAt;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("condition_groups")
    public List<RuleConditionGroupDetailResponseData> getConditionGroups() {
        return conditionGroups;
    }

    @JsonProperty("conditions")
    public List<RuleConditionDetailResponseData> getConditions() {
        return conditions;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("flag_id")
    public Optional<String> getFlagId() {
        return flagId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plan_id")
    public Optional<String> getPlanId() {
        return planId;
    }

    @JsonProperty("priority")
    public int getPriority() {
        return priority;
    }

    @JsonProperty("rule_type")
    public String getRuleType() {
        return ruleType;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("value")
    public boolean getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanAudienceDetailResponseData && equalTo((PlanAudienceDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanAudienceDetailResponseData other) {
        return conditionGroups.equals(other.conditionGroups)
                && conditions.equals(other.conditions)
                && createdAt.equals(other.createdAt)
                && environmentId.equals(other.environmentId)
                && flagId.equals(other.flagId)
                && id.equals(other.id)
                && name.equals(other.name)
                && planId.equals(other.planId)
                && priority == other.priority
                && ruleType.equals(other.ruleType)
                && updatedAt.equals(other.updatedAt)
                && value == other.value;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.conditionGroups,
                this.conditions,
                this.createdAt,
                this.environmentId,
                this.flagId,
                this.id,
                this.name,
                this.planId,
                this.priority,
                this.ruleType,
                this.updatedAt,
                this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(PlanAudienceDetailResponseData other);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        PriorityStage name(@NotNull String name);
    }

    public interface PriorityStage {
        RuleTypeStage priority(int priority);
    }

    public interface RuleTypeStage {
        UpdatedAtStage ruleType(@NotNull String ruleType);
    }

    public interface UpdatedAtStage {
        ValueStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface ValueStage {
        _FinalStage value(boolean value);
    }

    public interface _FinalStage {
        PlanAudienceDetailResponseData build();

        _FinalStage conditionGroups(List<RuleConditionGroupDetailResponseData> conditionGroups);

        _FinalStage addConditionGroups(RuleConditionGroupDetailResponseData conditionGroups);

        _FinalStage addAllConditionGroups(List<RuleConditionGroupDetailResponseData> conditionGroups);

        _FinalStage conditions(List<RuleConditionDetailResponseData> conditions);

        _FinalStage addConditions(RuleConditionDetailResponseData conditions);

        _FinalStage addAllConditions(List<RuleConditionDetailResponseData> conditions);

        _FinalStage flagId(Optional<String> flagId);

        _FinalStage flagId(String flagId);

        _FinalStage planId(Optional<String> planId);

        _FinalStage planId(String planId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    EnvironmentIdStage,
                    IdStage,
                    NameStage,
                    PriorityStage,
                    RuleTypeStage,
                    UpdatedAtStage,
                    ValueStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String environmentId;

        private String id;

        private String name;

        private int priority;

        private String ruleType;

        private OffsetDateTime updatedAt;

        private boolean value;

        private Optional<String> planId = Optional.empty();

        private Optional<String> flagId = Optional.empty();

        private List<RuleConditionDetailResponseData> conditions = new ArrayList<>();

        private List<RuleConditionGroupDetailResponseData> conditionGroups = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanAudienceDetailResponseData other) {
            conditionGroups(other.getConditionGroups());
            conditions(other.getConditions());
            createdAt(other.getCreatedAt());
            environmentId(other.getEnvironmentId());
            flagId(other.getFlagId());
            id(other.getId());
            name(other.getName());
            planId(other.getPlanId());
            priority(other.getPriority());
            ruleType(other.getRuleType());
            updatedAt(other.getUpdatedAt());
            value(other.getValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("priority")
        public RuleTypeStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @java.lang.Override
        @JsonSetter("rule_type")
        public UpdatedAtStage ruleType(@NotNull String ruleType) {
            this.ruleType = Objects.requireNonNull(ruleType, "ruleType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public ValueStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @java.lang.Override
        public _FinalStage planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_id", nulls = Nulls.SKIP)
        public _FinalStage planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        @java.lang.Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "flag_id", nulls = Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditions(List<RuleConditionDetailResponseData> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditions(RuleConditionDetailResponseData conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public _FinalStage conditions(List<RuleConditionDetailResponseData> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditionGroups(List<RuleConditionGroupDetailResponseData> conditionGroups) {
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditionGroups(RuleConditionGroupDetailResponseData conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "condition_groups", nulls = Nulls.SKIP)
        public _FinalStage conditionGroups(List<RuleConditionGroupDetailResponseData> conditionGroups) {
            this.conditionGroups.clear();
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @java.lang.Override
        public PlanAudienceDetailResponseData build() {
            return new PlanAudienceDetailResponseData(
                    conditionGroups,
                    conditions,
                    createdAt,
                    environmentId,
                    flagId,
                    id,
                    name,
                    planId,
                    priority,
                    ruleType,
                    updatedAt,
                    value,
                    additionalProperties);
        }
    }
}
