/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SegmentStatusResp.Builder.class)
public final class SegmentStatusResp {
    private final boolean connected;

    private final String environmentId;

    private final Optional<OffsetDateTime> lastEventAt;

    private final Map<String, Object> additionalProperties;

    private SegmentStatusResp(
            boolean connected,
            String environmentId,
            Optional<OffsetDateTime> lastEventAt,
            Map<String, Object> additionalProperties) {
        this.connected = connected;
        this.environmentId = environmentId;
        this.lastEventAt = lastEventAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("connected")
    public boolean getConnected() {
        return connected;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("last_event_at")
    public Optional<OffsetDateTime> getLastEventAt() {
        return lastEventAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SegmentStatusResp && equalTo((SegmentStatusResp) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SegmentStatusResp other) {
        return connected == other.connected
                && environmentId.equals(other.environmentId)
                && lastEventAt.equals(other.lastEventAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.connected, this.environmentId, this.lastEventAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConnectedStage builder() {
        return new Builder();
    }

    public interface ConnectedStage {
        EnvironmentIdStage connected(boolean connected);

        Builder from(SegmentStatusResp other);
    }

    public interface EnvironmentIdStage {
        _FinalStage environmentId(@NotNull String environmentId);
    }

    public interface _FinalStage {
        SegmentStatusResp build();

        _FinalStage lastEventAt(Optional<OffsetDateTime> lastEventAt);

        _FinalStage lastEventAt(OffsetDateTime lastEventAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConnectedStage, EnvironmentIdStage, _FinalStage {
        private boolean connected;

        private String environmentId;

        private Optional<OffsetDateTime> lastEventAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SegmentStatusResp other) {
            connected(other.getConnected());
            environmentId(other.getEnvironmentId());
            lastEventAt(other.getLastEventAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("connected")
        public EnvironmentIdStage connected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public _FinalStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage lastEventAt(OffsetDateTime lastEventAt) {
            this.lastEventAt = Optional.ofNullable(lastEventAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_event_at", nulls = Nulls.SKIP)
        public _FinalStage lastEventAt(Optional<OffsetDateTime> lastEventAt) {
            this.lastEventAt = lastEventAt;
            return this;
        }

        @java.lang.Override
        public SegmentStatusResp build() {
            return new SegmentStatusResp(connected, environmentId, lastEventAt, additionalProperties);
        }
    }
}
