/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accesstokens.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = IssueTemporaryAccessTokenRequestBody.Builder.class)
public final class IssueTemporaryAccessTokenRequestBody {
    private final Map<String, String> lookup;

    private final String resourceType;

    private final Map<String, Object> additionalProperties;

    private IssueTemporaryAccessTokenRequestBody(
            Map<String, String> lookup, String resourceType, Map<String, Object> additionalProperties) {
        this.lookup = lookup;
        this.resourceType = resourceType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("lookup")
    public Map<String, String> getLookup() {
        return lookup;
    }

    @JsonProperty("resource_type")
    public String getResourceType() {
        return resourceType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof IssueTemporaryAccessTokenRequestBody
                && equalTo((IssueTemporaryAccessTokenRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IssueTemporaryAccessTokenRequestBody other) {
        return lookup.equals(other.lookup) && resourceType.equals(other.resourceType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.lookup, this.resourceType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResourceTypeStage builder() {
        return new Builder();
    }

    public interface ResourceTypeStage {
        _FinalStage resourceType(@NotNull String resourceType);

        Builder from(IssueTemporaryAccessTokenRequestBody other);
    }

    public interface _FinalStage {
        IssueTemporaryAccessTokenRequestBody build();

        _FinalStage lookup(Map<String, String> lookup);

        _FinalStage putAllLookup(Map<String, String> lookup);

        _FinalStage lookup(String key, String value);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ResourceTypeStage, _FinalStage {
        private String resourceType;

        private Map<String, String> lookup = new LinkedHashMap<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(IssueTemporaryAccessTokenRequestBody other) {
            lookup(other.getLookup());
            resourceType(other.getResourceType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("resource_type")
        public _FinalStage resourceType(@NotNull String resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage lookup(String key, String value) {
            this.lookup.put(key, value);
            return this;
        }

        @java.lang.Override
        public _FinalStage putAllLookup(Map<String, String> lookup) {
            this.lookup.putAll(lookup);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "lookup", nulls = Nulls.SKIP)
        public _FinalStage lookup(Map<String, String> lookup) {
            this.lookup.clear();
            this.lookup.putAll(lookup);
            return this;
        }

        @java.lang.Override
        public IssueTemporaryAccessTokenRequestBody build() {
            return new IssueTemporaryAccessTokenRequestBody(lookup, resourceType, additionalProperties);
        }
    }
}
