/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingProductPricing;
import com.schematic.api.types.BillingSubscriptionDiscount;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateBillingSubscriptionsRequestBody.Builder.class)
public final class CreateBillingSubscriptionsRequestBody {
    private final String currency;

    private final String customerExternalId;

    private final List<BillingSubscriptionDiscount> discounts;

    private final OffsetDateTime expiredAt;

    private final Optional<String> interval;

    private final Optional<Map<String, JsonNode>> metadata;

    private final Optional<Integer> periodEnd;

    private final Optional<Integer> periodStart;

    private final List<BillingProductPricing> productExternalIds;

    private final Optional<String> status;

    private final String subscriptionExternalId;

    private final int totalPrice;

    private final Optional<Integer> trialEnd;

    private final Optional<String> trialEndSetting;

    private final Map<String, Object> additionalProperties;

    private CreateBillingSubscriptionsRequestBody(
            String currency,
            String customerExternalId,
            List<BillingSubscriptionDiscount> discounts,
            OffsetDateTime expiredAt,
            Optional<String> interval,
            Optional<Map<String, JsonNode>> metadata,
            Optional<Integer> periodEnd,
            Optional<Integer> periodStart,
            List<BillingProductPricing> productExternalIds,
            Optional<String> status,
            String subscriptionExternalId,
            int totalPrice,
            Optional<Integer> trialEnd,
            Optional<String> trialEndSetting,
            Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.discounts = discounts;
        this.expiredAt = expiredAt;
        this.interval = interval;
        this.metadata = metadata;
        this.periodEnd = periodEnd;
        this.periodStart = periodStart;
        this.productExternalIds = productExternalIds;
        this.status = status;
        this.subscriptionExternalId = subscriptionExternalId;
        this.totalPrice = totalPrice;
        this.trialEnd = trialEnd;
        this.trialEndSetting = trialEndSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("customer_external_id")
    public String getCustomerExternalId() {
        return customerExternalId;
    }

    @JsonProperty("discounts")
    public List<BillingSubscriptionDiscount> getDiscounts() {
        return discounts;
    }

    @JsonProperty("expired_at")
    public OffsetDateTime getExpiredAt() {
        return expiredAt;
    }

    @JsonProperty("interval")
    public Optional<String> getInterval() {
        return interval;
    }

    @JsonProperty("metadata")
    public Optional<Map<String, JsonNode>> getMetadata() {
        return metadata;
    }

    @JsonProperty("period_end")
    public Optional<Integer> getPeriodEnd() {
        return periodEnd;
    }

    @JsonProperty("period_start")
    public Optional<Integer> getPeriodStart() {
        return periodStart;
    }

    @JsonProperty("product_external_ids")
    public List<BillingProductPricing> getProductExternalIds() {
        return productExternalIds;
    }

    @JsonProperty("status")
    public Optional<String> getStatus() {
        return status;
    }

    @JsonProperty("subscription_external_id")
    public String getSubscriptionExternalId() {
        return subscriptionExternalId;
    }

    @JsonProperty("total_price")
    public int getTotalPrice() {
        return totalPrice;
    }

    @JsonProperty("trial_end")
    public Optional<Integer> getTrialEnd() {
        return trialEnd;
    }

    @JsonProperty("trial_end_setting")
    public Optional<String> getTrialEndSetting() {
        return trialEndSetting;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateBillingSubscriptionsRequestBody
                && equalTo((CreateBillingSubscriptionsRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingSubscriptionsRequestBody other) {
        return currency.equals(other.currency)
                && customerExternalId.equals(other.customerExternalId)
                && discounts.equals(other.discounts)
                && expiredAt.equals(other.expiredAt)
                && interval.equals(other.interval)
                && metadata.equals(other.metadata)
                && periodEnd.equals(other.periodEnd)
                && periodStart.equals(other.periodStart)
                && productExternalIds.equals(other.productExternalIds)
                && status.equals(other.status)
                && subscriptionExternalId.equals(other.subscriptionExternalId)
                && totalPrice == other.totalPrice
                && trialEnd.equals(other.trialEnd)
                && trialEndSetting.equals(other.trialEndSetting);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.currency,
                this.customerExternalId,
                this.discounts,
                this.expiredAt,
                this.interval,
                this.metadata,
                this.periodEnd,
                this.periodStart,
                this.productExternalIds,
                this.status,
                this.subscriptionExternalId,
                this.totalPrice,
                this.trialEnd,
                this.trialEndSetting);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    public interface CurrencyStage {
        CustomerExternalIdStage currency(@NotNull String currency);

        Builder from(CreateBillingSubscriptionsRequestBody other);
    }

    public interface CustomerExternalIdStage {
        ExpiredAtStage customerExternalId(@NotNull String customerExternalId);
    }

    public interface ExpiredAtStage {
        SubscriptionExternalIdStage expiredAt(@NotNull OffsetDateTime expiredAt);
    }

    public interface SubscriptionExternalIdStage {
        TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId);
    }

    public interface TotalPriceStage {
        _FinalStage totalPrice(int totalPrice);
    }

    public interface _FinalStage {
        CreateBillingSubscriptionsRequestBody build();

        _FinalStage discounts(List<BillingSubscriptionDiscount> discounts);

        _FinalStage addDiscounts(BillingSubscriptionDiscount discounts);

        _FinalStage addAllDiscounts(List<BillingSubscriptionDiscount> discounts);

        _FinalStage interval(Optional<String> interval);

        _FinalStage interval(String interval);

        _FinalStage metadata(Optional<Map<String, JsonNode>> metadata);

        _FinalStage metadata(Map<String, JsonNode> metadata);

        _FinalStage periodEnd(Optional<Integer> periodEnd);

        _FinalStage periodEnd(Integer periodEnd);

        _FinalStage periodStart(Optional<Integer> periodStart);

        _FinalStage periodStart(Integer periodStart);

        _FinalStage productExternalIds(List<BillingProductPricing> productExternalIds);

        _FinalStage addProductExternalIds(BillingProductPricing productExternalIds);

        _FinalStage addAllProductExternalIds(List<BillingProductPricing> productExternalIds);

        _FinalStage status(Optional<String> status);

        _FinalStage status(String status);

        _FinalStage trialEnd(Optional<Integer> trialEnd);

        _FinalStage trialEnd(Integer trialEnd);

        _FinalStage trialEndSetting(Optional<String> trialEndSetting);

        _FinalStage trialEndSetting(String trialEndSetting);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CurrencyStage,
                    CustomerExternalIdStage,
                    ExpiredAtStage,
                    SubscriptionExternalIdStage,
                    TotalPriceStage,
                    _FinalStage {
        private String currency;

        private String customerExternalId;

        private OffsetDateTime expiredAt;

        private String subscriptionExternalId;

        private int totalPrice;

        private Optional<String> trialEndSetting = Optional.empty();

        private Optional<Integer> trialEnd = Optional.empty();

        private Optional<String> status = Optional.empty();

        private List<BillingProductPricing> productExternalIds = new ArrayList<>();

        private Optional<Integer> periodStart = Optional.empty();

        private Optional<Integer> periodEnd = Optional.empty();

        private Optional<Map<String, JsonNode>> metadata = Optional.empty();

        private Optional<String> interval = Optional.empty();

        private List<BillingSubscriptionDiscount> discounts = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateBillingSubscriptionsRequestBody other) {
            currency(other.getCurrency());
            customerExternalId(other.getCustomerExternalId());
            discounts(other.getDiscounts());
            expiredAt(other.getExpiredAt());
            interval(other.getInterval());
            metadata(other.getMetadata());
            periodEnd(other.getPeriodEnd());
            periodStart(other.getPeriodStart());
            productExternalIds(other.getProductExternalIds());
            status(other.getStatus());
            subscriptionExternalId(other.getSubscriptionExternalId());
            totalPrice(other.getTotalPrice());
            trialEnd(other.getTrialEnd());
            trialEndSetting(other.getTrialEndSetting());
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("customer_external_id")
        public ExpiredAtStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("expired_at")
        public SubscriptionExternalIdStage expiredAt(@NotNull OffsetDateTime expiredAt) {
            this.expiredAt = Objects.requireNonNull(expiredAt, "expiredAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("subscription_external_id")
        public TotalPriceStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId =
                    Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialEndSetting(String trialEndSetting) {
            this.trialEndSetting = Optional.ofNullable(trialEndSetting);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_end_setting", nulls = Nulls.SKIP)
        public _FinalStage trialEndSetting(Optional<String> trialEndSetting) {
            this.trialEndSetting = trialEndSetting;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialEnd(Integer trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_end", nulls = Nulls.SKIP)
        public _FinalStage trialEnd(Optional<Integer> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<String> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllProductExternalIds(List<BillingProductPricing> productExternalIds) {
            this.productExternalIds.addAll(productExternalIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage addProductExternalIds(BillingProductPricing productExternalIds) {
            this.productExternalIds.add(productExternalIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "product_external_ids", nulls = Nulls.SKIP)
        public _FinalStage productExternalIds(List<BillingProductPricing> productExternalIds) {
            this.productExternalIds.clear();
            this.productExternalIds.addAll(productExternalIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage periodStart(Integer periodStart) {
            this.periodStart = Optional.ofNullable(periodStart);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "period_start", nulls = Nulls.SKIP)
        public _FinalStage periodStart(Optional<Integer> periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        @java.lang.Override
        public _FinalStage periodEnd(Integer periodEnd) {
            this.periodEnd = Optional.ofNullable(periodEnd);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "period_end", nulls = Nulls.SKIP)
        public _FinalStage periodEnd(Optional<Integer> periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        @java.lang.Override
        public _FinalStage metadata(Map<String, JsonNode> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, JsonNode>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @java.lang.Override
        public _FinalStage interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "interval", nulls = Nulls.SKIP)
        public _FinalStage interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllDiscounts(List<BillingSubscriptionDiscount> discounts) {
            this.discounts.addAll(discounts);
            return this;
        }

        @java.lang.Override
        public _FinalStage addDiscounts(BillingSubscriptionDiscount discounts) {
            this.discounts.add(discounts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "discounts", nulls = Nulls.SKIP)
        public _FinalStage discounts(List<BillingSubscriptionDiscount> discounts) {
            this.discounts.clear();
            this.discounts.addAll(discounts);
            return this;
        }

        @java.lang.Override
        public CreateBillingSubscriptionsRequestBody build() {
            return new CreateBillingSubscriptionsRequestBody(
                    currency,
                    customerExternalId,
                    discounts,
                    expiredAt,
                    interval,
                    metadata,
                    periodEnd,
                    periodStart,
                    productExternalIds,
                    status,
                    subscriptionExternalId,
                    totalPrice,
                    trialEnd,
                    trialEndSetting,
                    additionalProperties);
        }
    }
}
