/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.companies.types.CreateEntityTraitDefinitionRequestBodyEntityType;
import com.schematic.api.resources.companies.types.CreateEntityTraitDefinitionRequestBodyTraitType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateEntityTraitDefinitionRequestBody.Builder.class)
public final class CreateEntityTraitDefinitionRequestBody {
    private final Optional<String> displayName;

    private final CreateEntityTraitDefinitionRequestBodyEntityType entityType;

    private final List<String> hierarchy;

    private final CreateEntityTraitDefinitionRequestBodyTraitType traitType;

    private final Map<String, Object> additionalProperties;

    private CreateEntityTraitDefinitionRequestBody(
            Optional<String> displayName,
            CreateEntityTraitDefinitionRequestBodyEntityType entityType,
            List<String> hierarchy,
            CreateEntityTraitDefinitionRequestBodyTraitType traitType,
            Map<String, Object> additionalProperties) {
        this.displayName = displayName;
        this.entityType = entityType;
        this.hierarchy = hierarchy;
        this.traitType = traitType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("display_name")
    public Optional<String> getDisplayName() {
        return displayName;
    }

    @JsonProperty("entity_type")
    public CreateEntityTraitDefinitionRequestBodyEntityType getEntityType() {
        return entityType;
    }

    @JsonProperty("hierarchy")
    public List<String> getHierarchy() {
        return hierarchy;
    }

    @JsonProperty("trait_type")
    public CreateEntityTraitDefinitionRequestBodyTraitType getTraitType() {
        return traitType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateEntityTraitDefinitionRequestBody
                && equalTo((CreateEntityTraitDefinitionRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateEntityTraitDefinitionRequestBody other) {
        return displayName.equals(other.displayName)
                && entityType.equals(other.entityType)
                && hierarchy.equals(other.hierarchy)
                && traitType.equals(other.traitType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.displayName, this.entityType, this.hierarchy, this.traitType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntityTypeStage builder() {
        return new Builder();
    }

    public interface EntityTypeStage {
        TraitTypeStage entityType(@NotNull CreateEntityTraitDefinitionRequestBodyEntityType entityType);

        Builder from(CreateEntityTraitDefinitionRequestBody other);
    }

    public interface TraitTypeStage {
        _FinalStage traitType(@NotNull CreateEntityTraitDefinitionRequestBodyTraitType traitType);
    }

    public interface _FinalStage {
        CreateEntityTraitDefinitionRequestBody build();

        _FinalStage displayName(Optional<String> displayName);

        _FinalStage displayName(String displayName);

        _FinalStage hierarchy(List<String> hierarchy);

        _FinalStage addHierarchy(String hierarchy);

        _FinalStage addAllHierarchy(List<String> hierarchy);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements EntityTypeStage, TraitTypeStage, _FinalStage {
        private CreateEntityTraitDefinitionRequestBodyEntityType entityType;

        private CreateEntityTraitDefinitionRequestBodyTraitType traitType;

        private List<String> hierarchy = new ArrayList<>();

        private Optional<String> displayName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateEntityTraitDefinitionRequestBody other) {
            displayName(other.getDisplayName());
            entityType(other.getEntityType());
            hierarchy(other.getHierarchy());
            traitType(other.getTraitType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("entity_type")
        public TraitTypeStage entityType(@NotNull CreateEntityTraitDefinitionRequestBodyEntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_type")
        public _FinalStage traitType(@NotNull CreateEntityTraitDefinitionRequestBodyTraitType traitType) {
            this.traitType = Objects.requireNonNull(traitType, "traitType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllHierarchy(List<String> hierarchy) {
            this.hierarchy.addAll(hierarchy);
            return this;
        }

        @java.lang.Override
        public _FinalStage addHierarchy(String hierarchy) {
            this.hierarchy.add(hierarchy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "hierarchy", nulls = Nulls.SKIP)
        public _FinalStage hierarchy(List<String> hierarchy) {
            this.hierarchy.clear();
            this.hierarchy.addAll(hierarchy);
            return this;
        }

        @java.lang.Override
        public _FinalStage displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "display_name", nulls = Nulls.SKIP)
        public _FinalStage displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        @java.lang.Override
        public CreateEntityTraitDefinitionRequestBody build() {
            return new CreateEntityTraitDefinitionRequestBody(
                    displayName, entityType, hierarchy, traitType, additionalProperties);
        }
    }
}
