/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GetActiveDealsRequest.Builder.class)
public final class GetActiveDealsRequest {
    private final String companyId;

    private final String dealStage;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private GetActiveDealsRequest(
            String companyId,
            String dealStage,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.dealStage = dealStage;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("deal_stage")
    public String getDealStage() {
        return dealStage;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GetActiveDealsRequest && equalTo((GetActiveDealsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetActiveDealsRequest other) {
        return companyId.equals(other.companyId)
                && dealStage.equals(other.dealStage)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.dealStage, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        DealStageStage companyId(@NotNull String companyId);

        Builder from(GetActiveDealsRequest other);
    }

    public interface DealStageStage {
        _FinalStage dealStage(@NotNull String dealStage);
    }

    public interface _FinalStage {
        GetActiveDealsRequest build();

        _FinalStage limit(Optional<Integer> limit);

        _FinalStage limit(Integer limit);

        _FinalStage offset(Optional<Integer> offset);

        _FinalStage offset(Integer offset);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CompanyIdStage, DealStageStage, _FinalStage {
        private String companyId;

        private String dealStage;

        private Optional<Integer> offset = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GetActiveDealsRequest other) {
            companyId(other.getCompanyId());
            dealStage(other.getDealStage());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public DealStageStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("deal_stage")
        public _FinalStage dealStage(@NotNull String dealStage) {
            this.dealStage = Objects.requireNonNull(dealStage, "dealStage must not be null");
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        public GetActiveDealsRequest build() {
            return new GetActiveDealsRequest(companyId, dealStage, limit, offset, additionalProperties);
        }
    }
}
