/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCrmLineItemRequestBody.Builder.class)
public final class CreateCrmLineItemRequestBody {
    private final String amount;

    private final Optional<String> discountPercentage;

    private final String interval;

    private final String lineItemExternalId;

    private final String productExternalId;

    private final int quantity;

    private final Optional<Integer> termMonth;

    private final Optional<String> totalDiscount;

    private final Map<String, Object> additionalProperties;

    private CreateCrmLineItemRequestBody(
            String amount,
            Optional<String> discountPercentage,
            String interval,
            String lineItemExternalId,
            String productExternalId,
            int quantity,
            Optional<Integer> termMonth,
            Optional<String> totalDiscount,
            Map<String, Object> additionalProperties) {
        this.amount = amount;
        this.discountPercentage = discountPercentage;
        this.interval = interval;
        this.lineItemExternalId = lineItemExternalId;
        this.productExternalId = productExternalId;
        this.quantity = quantity;
        this.termMonth = termMonth;
        this.totalDiscount = totalDiscount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount")
    public String getAmount() {
        return amount;
    }

    @JsonProperty("discount_percentage")
    public Optional<String> getDiscountPercentage() {
        return discountPercentage;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("line_item_external_id")
    public String getLineItemExternalId() {
        return lineItemExternalId;
    }

    @JsonProperty("product_external_id")
    public String getProductExternalId() {
        return productExternalId;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("term_month")
    public Optional<Integer> getTermMonth() {
        return termMonth;
    }

    @JsonProperty("total_discount")
    public Optional<String> getTotalDiscount() {
        return totalDiscount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCrmLineItemRequestBody && equalTo((CreateCrmLineItemRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmLineItemRequestBody other) {
        return amount.equals(other.amount)
                && discountPercentage.equals(other.discountPercentage)
                && interval.equals(other.interval)
                && lineItemExternalId.equals(other.lineItemExternalId)
                && productExternalId.equals(other.productExternalId)
                && quantity == other.quantity
                && termMonth.equals(other.termMonth)
                && totalDiscount.equals(other.totalDiscount);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.amount,
                this.discountPercentage,
                this.interval,
                this.lineItemExternalId,
                this.productExternalId,
                this.quantity,
                this.termMonth,
                this.totalDiscount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountStage builder() {
        return new Builder();
    }

    public interface AmountStage {
        IntervalStage amount(@NotNull String amount);

        Builder from(CreateCrmLineItemRequestBody other);
    }

    public interface IntervalStage {
        LineItemExternalIdStage interval(@NotNull String interval);
    }

    public interface LineItemExternalIdStage {
        ProductExternalIdStage lineItemExternalId(@NotNull String lineItemExternalId);
    }

    public interface ProductExternalIdStage {
        QuantityStage productExternalId(@NotNull String productExternalId);
    }

    public interface QuantityStage {
        _FinalStage quantity(int quantity);
    }

    public interface _FinalStage {
        CreateCrmLineItemRequestBody build();

        _FinalStage discountPercentage(Optional<String> discountPercentage);

        _FinalStage discountPercentage(String discountPercentage);

        _FinalStage termMonth(Optional<Integer> termMonth);

        _FinalStage termMonth(Integer termMonth);

        _FinalStage totalDiscount(Optional<String> totalDiscount);

        _FinalStage totalDiscount(String totalDiscount);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AmountStage,
                    IntervalStage,
                    LineItemExternalIdStage,
                    ProductExternalIdStage,
                    QuantityStage,
                    _FinalStage {
        private String amount;

        private String interval;

        private String lineItemExternalId;

        private String productExternalId;

        private int quantity;

        private Optional<String> totalDiscount = Optional.empty();

        private Optional<Integer> termMonth = Optional.empty();

        private Optional<String> discountPercentage = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCrmLineItemRequestBody other) {
            amount(other.getAmount());
            discountPercentage(other.getDiscountPercentage());
            interval(other.getInterval());
            lineItemExternalId(other.getLineItemExternalId());
            productExternalId(other.getProductExternalId());
            quantity(other.getQuantity());
            termMonth(other.getTermMonth());
            totalDiscount(other.getTotalDiscount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount")
        public IntervalStage amount(@NotNull String amount) {
            this.amount = Objects.requireNonNull(amount, "amount must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public LineItemExternalIdStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("line_item_external_id")
        public ProductExternalIdStage lineItemExternalId(@NotNull String lineItemExternalId) {
            this.lineItemExternalId = Objects.requireNonNull(lineItemExternalId, "lineItemExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_external_id")
        public QuantityStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public _FinalStage totalDiscount(String totalDiscount) {
            this.totalDiscount = Optional.ofNullable(totalDiscount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "total_discount", nulls = Nulls.SKIP)
        public _FinalStage totalDiscount(Optional<String> totalDiscount) {
            this.totalDiscount = totalDiscount;
            return this;
        }

        @java.lang.Override
        public _FinalStage termMonth(Integer termMonth) {
            this.termMonth = Optional.ofNullable(termMonth);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "term_month", nulls = Nulls.SKIP)
        public _FinalStage termMonth(Optional<Integer> termMonth) {
            this.termMonth = termMonth;
            return this;
        }

        @java.lang.Override
        public _FinalStage discountPercentage(String discountPercentage) {
            this.discountPercentage = Optional.ofNullable(discountPercentage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "discount_percentage", nulls = Nulls.SKIP)
        public _FinalStage discountPercentage(Optional<String> discountPercentage) {
            this.discountPercentage = discountPercentage;
            return this;
        }

        @java.lang.Override
        public CreateCrmLineItemRequestBody build() {
            return new CreateCrmLineItemRequestBody(
                    amount,
                    discountPercentage,
                    interval,
                    lineItemExternalId,
                    productExternalId,
                    quantity,
                    termMonth,
                    totalDiscount,
                    additionalProperties);
        }
    }
}
