/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.plans.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CountPlansParams.Builder.class)
public final class CountPlansParams {
    private final Optional<String> companyId;

    private final Optional<Boolean> hasProductId;

    private final Optional<List<String>> ids;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<CountPlansResponseParamsPlanType> planType;

    private final Optional<String> q;

    private final Optional<String> withoutEntitlementFor;

    private final Optional<Boolean> withoutPaidProductId;

    private final Optional<Boolean> withoutProductId;

    private final Map<String, Object> additionalProperties;

    private CountPlansParams(
            Optional<String> companyId,
            Optional<Boolean> hasProductId,
            Optional<List<String>> ids,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<CountPlansResponseParamsPlanType> planType,
            Optional<String> q,
            Optional<String> withoutEntitlementFor,
            Optional<Boolean> withoutPaidProductId,
            Optional<Boolean> withoutProductId,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.hasProductId = hasProductId;
        this.ids = ids;
        this.limit = limit;
        this.offset = offset;
        this.planType = planType;
        this.q = q;
        this.withoutEntitlementFor = withoutEntitlementFor;
        this.withoutPaidProductId = withoutPaidProductId;
        this.withoutProductId = withoutProductId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return Filter out plans that do not have a billing product ID
     */
    @JsonProperty("has_product_id")
    public Optional<Boolean> getHasProductId() {
        return hasProductId;
    }

    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    /**
     * @return Filter by plan type
     */
    @JsonProperty("plan_type")
    public Optional<CountPlansResponseParamsPlanType> getPlanType() {
        return planType;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    /**
     * @return Filter out plans that already have a plan entitlement for the specified feature ID
     */
    @JsonProperty("without_entitlement_for")
    public Optional<String> getWithoutEntitlementFor() {
        return withoutEntitlementFor;
    }

    /**
     * @return Filter out plans that have a paid billing product ID
     */
    @JsonProperty("without_paid_product_id")
    public Optional<Boolean> getWithoutPaidProductId() {
        return withoutPaidProductId;
    }

    /**
     * @return Filter out plans that have a billing product ID
     */
    @JsonProperty("without_product_id")
    public Optional<Boolean> getWithoutProductId() {
        return withoutProductId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CountPlansParams && equalTo((CountPlansParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountPlansParams other) {
        return companyId.equals(other.companyId)
                && hasProductId.equals(other.hasProductId)
                && ids.equals(other.ids)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && planType.equals(other.planType)
                && q.equals(other.q)
                && withoutEntitlementFor.equals(other.withoutEntitlementFor)
                && withoutPaidProductId.equals(other.withoutPaidProductId)
                && withoutProductId.equals(other.withoutProductId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId,
                this.hasProductId,
                this.ids,
                this.limit,
                this.offset,
                this.planType,
                this.q,
                this.withoutEntitlementFor,
                this.withoutPaidProductId,
                this.withoutProductId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();

        private Optional<Boolean> hasProductId = Optional.empty();

        private Optional<List<String>> ids = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<CountPlansResponseParamsPlanType> planType = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<String> withoutEntitlementFor = Optional.empty();

        private Optional<Boolean> withoutPaidProductId = Optional.empty();

        private Optional<Boolean> withoutProductId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CountPlansParams other) {
            companyId(other.getCompanyId());
            hasProductId(other.getHasProductId());
            ids(other.getIds());
            limit(other.getLimit());
            offset(other.getOffset());
            planType(other.getPlanType());
            q(other.getQ());
            withoutEntitlementFor(other.getWithoutEntitlementFor());
            withoutPaidProductId(other.getWithoutPaidProductId());
            withoutProductId(other.getWithoutProductId());
            return this;
        }

        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value = "has_product_id", nulls = Nulls.SKIP)
        public Builder hasProductId(Optional<Boolean> hasProductId) {
            this.hasProductId = hasProductId;
            return this;
        }

        public Builder hasProductId(Boolean hasProductId) {
            this.hasProductId = Optional.ofNullable(hasProductId);
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "plan_type", nulls = Nulls.SKIP)
        public Builder planType(Optional<CountPlansResponseParamsPlanType> planType) {
            this.planType = planType;
            return this;
        }

        public Builder planType(CountPlansResponseParamsPlanType planType) {
            this.planType = Optional.ofNullable(planType);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value = "without_entitlement_for", nulls = Nulls.SKIP)
        public Builder withoutEntitlementFor(Optional<String> withoutEntitlementFor) {
            this.withoutEntitlementFor = withoutEntitlementFor;
            return this;
        }

        public Builder withoutEntitlementFor(String withoutEntitlementFor) {
            this.withoutEntitlementFor = Optional.ofNullable(withoutEntitlementFor);
            return this;
        }

        @JsonSetter(value = "without_paid_product_id", nulls = Nulls.SKIP)
        public Builder withoutPaidProductId(Optional<Boolean> withoutPaidProductId) {
            this.withoutPaidProductId = withoutPaidProductId;
            return this;
        }

        public Builder withoutPaidProductId(Boolean withoutPaidProductId) {
            this.withoutPaidProductId = Optional.ofNullable(withoutPaidProductId);
            return this;
        }

        @JsonSetter(value = "without_product_id", nulls = Nulls.SKIP)
        public Builder withoutProductId(Optional<Boolean> withoutProductId) {
            this.withoutProductId = withoutProductId;
            return this;
        }

        public Builder withoutProductId(Boolean withoutProductId) {
            this.withoutProductId = Optional.ofNullable(withoutProductId);
            return this;
        }

        public CountPlansParams build() {
            return new CountPlansParams(
                    companyId,
                    hasProductId,
                    ids,
                    limit,
                    offset,
                    planType,
                    q,
                    withoutEntitlementFor,
                    withoutPaidProductId,
                    withoutProductId,
                    additionalProperties);
        }
    }
}
