/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingCustomerSubscription.Builder.class)
public final class BillingCustomerSubscription {
    private final String currency;

    private final Optional<OffsetDateTime> expiredAt;

    private final String interval;

    private final boolean meteredUsage;

    private final int perUnitPrice;

    private final int totalPrice;

    private final Map<String, Object> additionalProperties;

    private BillingCustomerSubscription(
            String currency,
            Optional<OffsetDateTime> expiredAt,
            String interval,
            boolean meteredUsage,
            int perUnitPrice,
            int totalPrice,
            Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.expiredAt = expiredAt;
        this.interval = interval;
        this.meteredUsage = meteredUsage;
        this.perUnitPrice = perUnitPrice;
        this.totalPrice = totalPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return expiredAt;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("metered_usage")
    public boolean getMeteredUsage() {
        return meteredUsage;
    }

    @JsonProperty("per_unit_price")
    public int getPerUnitPrice() {
        return perUnitPrice;
    }

    @JsonProperty("total_price")
    public int getTotalPrice() {
        return totalPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingCustomerSubscription && equalTo((BillingCustomerSubscription) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCustomerSubscription other) {
        return currency.equals(other.currency)
                && expiredAt.equals(other.expiredAt)
                && interval.equals(other.interval)
                && meteredUsage == other.meteredUsage
                && perUnitPrice == other.perUnitPrice
                && totalPrice == other.totalPrice;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.currency, this.expiredAt, this.interval, this.meteredUsage, this.perUnitPrice, this.totalPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    public interface CurrencyStage {
        IntervalStage currency(@NotNull String currency);

        Builder from(BillingCustomerSubscription other);
    }

    public interface IntervalStage {
        MeteredUsageStage interval(@NotNull String interval);
    }

    public interface MeteredUsageStage {
        PerUnitPriceStage meteredUsage(boolean meteredUsage);
    }

    public interface PerUnitPriceStage {
        TotalPriceStage perUnitPrice(int perUnitPrice);
    }

    public interface TotalPriceStage {
        _FinalStage totalPrice(int totalPrice);
    }

    public interface _FinalStage {
        BillingCustomerSubscription build();

        _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt);

        _FinalStage expiredAt(OffsetDateTime expiredAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CurrencyStage,
                    IntervalStage,
                    MeteredUsageStage,
                    PerUnitPriceStage,
                    TotalPriceStage,
                    _FinalStage {
        private String currency;

        private String interval;

        private boolean meteredUsage;

        private int perUnitPrice;

        private int totalPrice;

        private Optional<OffsetDateTime> expiredAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingCustomerSubscription other) {
            currency(other.getCurrency());
            expiredAt(other.getExpiredAt());
            interval(other.getInterval());
            meteredUsage(other.getMeteredUsage());
            perUnitPrice(other.getPerUnitPrice());
            totalPrice(other.getTotalPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public IntervalStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public MeteredUsageStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("metered_usage")
        public PerUnitPriceStage meteredUsage(boolean meteredUsage) {
            this.meteredUsage = meteredUsage;
            return this;
        }

        @java.lang.Override
        @JsonSetter("per_unit_price")
        public TotalPriceStage perUnitPrice(int perUnitPrice) {
            this.perUnitPrice = perUnitPrice;
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expired_at", nulls = Nulls.SKIP)
        public _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        @java.lang.Override
        public BillingCustomerSubscription build() {
            return new BillingCustomerSubscription(
                    currency, expiredAt, interval, meteredUsage, perUnitPrice, totalPrice, additionalProperties);
        }
    }
}
