/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingProductPlanResponseData.Builder.class)
public final class BillingProductPlanResponseData {
    private final String accountId;

    private final String billingProductId;

    private final String environmentId;

    private final boolean isTrialable;

    private final Optional<String> monthlyPriceId;

    private final String planId;

    private final Optional<Integer> trialDays;

    private final Optional<String> yearlyPriceId;

    private final Map<String, Object> additionalProperties;

    private BillingProductPlanResponseData(
            String accountId,
            String billingProductId,
            String environmentId,
            boolean isTrialable,
            Optional<String> monthlyPriceId,
            String planId,
            Optional<Integer> trialDays,
            Optional<String> yearlyPriceId,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.billingProductId = billingProductId;
        this.environmentId = environmentId;
        this.isTrialable = isTrialable;
        this.monthlyPriceId = monthlyPriceId;
        this.planId = planId;
        this.trialDays = trialDays;
        this.yearlyPriceId = yearlyPriceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("billing_product_id")
    public String getBillingProductId() {
        return billingProductId;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("is_trialable")
    public boolean getIsTrialable() {
        return isTrialable;
    }

    @JsonProperty("monthly_price_id")
    public Optional<String> getMonthlyPriceId() {
        return monthlyPriceId;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("trial_days")
    public Optional<Integer> getTrialDays() {
        return trialDays;
    }

    @JsonProperty("yearly_price_id")
    public Optional<String> getYearlyPriceId() {
        return yearlyPriceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingProductPlanResponseData && equalTo((BillingProductPlanResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPlanResponseData other) {
        return accountId.equals(other.accountId)
                && billingProductId.equals(other.billingProductId)
                && environmentId.equals(other.environmentId)
                && isTrialable == other.isTrialable
                && monthlyPriceId.equals(other.monthlyPriceId)
                && planId.equals(other.planId)
                && trialDays.equals(other.trialDays)
                && yearlyPriceId.equals(other.yearlyPriceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.billingProductId,
                this.environmentId,
                this.isTrialable,
                this.monthlyPriceId,
                this.planId,
                this.trialDays,
                this.yearlyPriceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        BillingProductIdStage accountId(@NotNull String accountId);

        Builder from(BillingProductPlanResponseData other);
    }

    public interface BillingProductIdStage {
        EnvironmentIdStage billingProductId(@NotNull String billingProductId);
    }

    public interface EnvironmentIdStage {
        IsTrialableStage environmentId(@NotNull String environmentId);
    }

    public interface IsTrialableStage {
        PlanIdStage isTrialable(boolean isTrialable);
    }

    public interface PlanIdStage {
        _FinalStage planId(@NotNull String planId);
    }

    public interface _FinalStage {
        BillingProductPlanResponseData build();

        _FinalStage monthlyPriceId(Optional<String> monthlyPriceId);

        _FinalStage monthlyPriceId(String monthlyPriceId);

        _FinalStage trialDays(Optional<Integer> trialDays);

        _FinalStage trialDays(Integer trialDays);

        _FinalStage yearlyPriceId(Optional<String> yearlyPriceId);

        _FinalStage yearlyPriceId(String yearlyPriceId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    BillingProductIdStage,
                    EnvironmentIdStage,
                    IsTrialableStage,
                    PlanIdStage,
                    _FinalStage {
        private String accountId;

        private String billingProductId;

        private String environmentId;

        private boolean isTrialable;

        private String planId;

        private Optional<String> yearlyPriceId = Optional.empty();

        private Optional<Integer> trialDays = Optional.empty();

        private Optional<String> monthlyPriceId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingProductPlanResponseData other) {
            accountId(other.getAccountId());
            billingProductId(other.getBillingProductId());
            environmentId(other.getEnvironmentId());
            isTrialable(other.getIsTrialable());
            monthlyPriceId(other.getMonthlyPriceId());
            planId(other.getPlanId());
            trialDays(other.getTrialDays());
            yearlyPriceId(other.getYearlyPriceId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public BillingProductIdStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("billing_product_id")
        public EnvironmentIdStage billingProductId(@NotNull String billingProductId) {
            this.billingProductId = Objects.requireNonNull(billingProductId, "billingProductId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IsTrialableStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_trialable")
        public PlanIdStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyPriceId(String yearlyPriceId) {
            this.yearlyPriceId = Optional.ofNullable(yearlyPriceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_price_id", nulls = Nulls.SKIP)
        public _FinalStage yearlyPriceId(Optional<String> yearlyPriceId) {
            this.yearlyPriceId = yearlyPriceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_days", nulls = Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyPriceId(String monthlyPriceId) {
            this.monthlyPriceId = Optional.ofNullable(monthlyPriceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_price_id", nulls = Nulls.SKIP)
        public _FinalStage monthlyPriceId(Optional<String> monthlyPriceId) {
            this.monthlyPriceId = monthlyPriceId;
            return this;
        }

        @java.lang.Override
        public BillingProductPlanResponseData build() {
            return new BillingProductPlanResponseData(
                    accountId,
                    billingProductId,
                    environmentId,
                    isTrialable,
                    monthlyPriceId,
                    planId,
                    trialDays,
                    yearlyPriceId,
                    additionalProperties);
        }
    }
}
