/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = InvoiceResponseData.Builder.class)
public final class InvoiceResponseData {
    private final int amountDue;

    private final int amountPaid;

    private final int amountRemaining;

    private final String collectionMethod;

    private final Optional<String> companyId;

    private final OffsetDateTime createdAt;

    private final String currency;

    private final String customerExternalId;

    private final Optional<OffsetDateTime> dueDate;

    private final String environmentId;

    private final Optional<String> externalId;

    private final String id;

    private final Optional<String> paymentMethodExternalId;

    private final Optional<String> subscriptionExternalId;

    private final int subtotal;

    private final OffsetDateTime updatedAt;

    private final Optional<String> url;

    private final Map<String, Object> additionalProperties;

    private InvoiceResponseData(
            int amountDue,
            int amountPaid,
            int amountRemaining,
            String collectionMethod,
            Optional<String> companyId,
            OffsetDateTime createdAt,
            String currency,
            String customerExternalId,
            Optional<OffsetDateTime> dueDate,
            String environmentId,
            Optional<String> externalId,
            String id,
            Optional<String> paymentMethodExternalId,
            Optional<String> subscriptionExternalId,
            int subtotal,
            OffsetDateTime updatedAt,
            Optional<String> url,
            Map<String, Object> additionalProperties) {
        this.amountDue = amountDue;
        this.amountPaid = amountPaid;
        this.amountRemaining = amountRemaining;
        this.collectionMethod = collectionMethod;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.customerExternalId = customerExternalId;
        this.dueDate = dueDate;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.id = id;
        this.paymentMethodExternalId = paymentMethodExternalId;
        this.subscriptionExternalId = subscriptionExternalId;
        this.subtotal = subtotal;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount_due")
    public int getAmountDue() {
        return amountDue;
    }

    @JsonProperty("amount_paid")
    public int getAmountPaid() {
        return amountPaid;
    }

    @JsonProperty("amount_remaining")
    public int getAmountRemaining() {
        return amountRemaining;
    }

    @JsonProperty("collection_method")
    public String getCollectionMethod() {
        return collectionMethod;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("customer_external_id")
    public String getCustomerExternalId() {
        return customerExternalId;
    }

    @JsonProperty("due_date")
    public Optional<OffsetDateTime> getDueDate() {
        return dueDate;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("payment_method_external_id")
    public Optional<String> getPaymentMethodExternalId() {
        return paymentMethodExternalId;
    }

    @JsonProperty("subscription_external_id")
    public Optional<String> getSubscriptionExternalId() {
        return subscriptionExternalId;
    }

    @JsonProperty("subtotal")
    public int getSubtotal() {
        return subtotal;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof InvoiceResponseData && equalTo((InvoiceResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceResponseData other) {
        return amountDue == other.amountDue
                && amountPaid == other.amountPaid
                && amountRemaining == other.amountRemaining
                && collectionMethod.equals(other.collectionMethod)
                && companyId.equals(other.companyId)
                && createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && customerExternalId.equals(other.customerExternalId)
                && dueDate.equals(other.dueDate)
                && environmentId.equals(other.environmentId)
                && externalId.equals(other.externalId)
                && id.equals(other.id)
                && paymentMethodExternalId.equals(other.paymentMethodExternalId)
                && subscriptionExternalId.equals(other.subscriptionExternalId)
                && subtotal == other.subtotal
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.amountDue,
                this.amountPaid,
                this.amountRemaining,
                this.collectionMethod,
                this.companyId,
                this.createdAt,
                this.currency,
                this.customerExternalId,
                this.dueDate,
                this.environmentId,
                this.externalId,
                this.id,
                this.paymentMethodExternalId,
                this.subscriptionExternalId,
                this.subtotal,
                this.updatedAt,
                this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountDueStage builder() {
        return new Builder();
    }

    public interface AmountDueStage {
        AmountPaidStage amountDue(int amountDue);

        Builder from(InvoiceResponseData other);
    }

    public interface AmountPaidStage {
        AmountRemainingStage amountPaid(int amountPaid);
    }

    public interface AmountRemainingStage {
        CollectionMethodStage amountRemaining(int amountRemaining);
    }

    public interface CollectionMethodStage {
        CreatedAtStage collectionMethod(@NotNull String collectionMethod);
    }

    public interface CreatedAtStage {
        CurrencyStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CurrencyStage {
        CustomerExternalIdStage currency(@NotNull String currency);
    }

    public interface CustomerExternalIdStage {
        EnvironmentIdStage customerExternalId(@NotNull String customerExternalId);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        SubtotalStage id(@NotNull String id);
    }

    public interface SubtotalStage {
        UpdatedAtStage subtotal(int subtotal);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        InvoiceResponseData build();

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage dueDate(Optional<OffsetDateTime> dueDate);

        _FinalStage dueDate(OffsetDateTime dueDate);

        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);

        _FinalStage paymentMethodExternalId(Optional<String> paymentMethodExternalId);

        _FinalStage paymentMethodExternalId(String paymentMethodExternalId);

        _FinalStage subscriptionExternalId(Optional<String> subscriptionExternalId);

        _FinalStage subscriptionExternalId(String subscriptionExternalId);

        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AmountDueStage,
                    AmountPaidStage,
                    AmountRemainingStage,
                    CollectionMethodStage,
                    CreatedAtStage,
                    CurrencyStage,
                    CustomerExternalIdStage,
                    EnvironmentIdStage,
                    IdStage,
                    SubtotalStage,
                    UpdatedAtStage,
                    _FinalStage {
        private int amountDue;

        private int amountPaid;

        private int amountRemaining;

        private String collectionMethod;

        private OffsetDateTime createdAt;

        private String currency;

        private String customerExternalId;

        private String environmentId;

        private String id;

        private int subtotal;

        private OffsetDateTime updatedAt;

        private Optional<String> url = Optional.empty();

        private Optional<String> subscriptionExternalId = Optional.empty();

        private Optional<String> paymentMethodExternalId = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<OffsetDateTime> dueDate = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(InvoiceResponseData other) {
            amountDue(other.getAmountDue());
            amountPaid(other.getAmountPaid());
            amountRemaining(other.getAmountRemaining());
            collectionMethod(other.getCollectionMethod());
            companyId(other.getCompanyId());
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            customerExternalId(other.getCustomerExternalId());
            dueDate(other.getDueDate());
            environmentId(other.getEnvironmentId());
            externalId(other.getExternalId());
            id(other.getId());
            paymentMethodExternalId(other.getPaymentMethodExternalId());
            subscriptionExternalId(other.getSubscriptionExternalId());
            subtotal(other.getSubtotal());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_due")
        public AmountPaidStage amountDue(int amountDue) {
            this.amountDue = amountDue;
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_paid")
        public AmountRemainingStage amountPaid(int amountPaid) {
            this.amountPaid = amountPaid;
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_remaining")
        public CollectionMethodStage amountRemaining(int amountRemaining) {
            this.amountRemaining = amountRemaining;
            return this;
        }

        @java.lang.Override
        @JsonSetter("collection_method")
        public CreatedAtStage collectionMethod(@NotNull String collectionMethod) {
            this.collectionMethod = Objects.requireNonNull(collectionMethod, "collectionMethod must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public CustomerExternalIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("customer_external_id")
        public EnvironmentIdStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public SubtotalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("subtotal")
        public UpdatedAtStage subtotal(int subtotal) {
            this.subtotal = subtotal;
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @java.lang.Override
        public _FinalStage subscriptionExternalId(String subscriptionExternalId) {
            this.subscriptionExternalId = Optional.ofNullable(subscriptionExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "subscription_external_id", nulls = Nulls.SKIP)
        public _FinalStage subscriptionExternalId(Optional<String> subscriptionExternalId) {
            this.subscriptionExternalId = subscriptionExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage paymentMethodExternalId(String paymentMethodExternalId) {
            this.paymentMethodExternalId = Optional.ofNullable(paymentMethodExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "payment_method_external_id", nulls = Nulls.SKIP)
        public _FinalStage paymentMethodExternalId(Optional<String> paymentMethodExternalId) {
            this.paymentMethodExternalId = paymentMethodExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage dueDate(OffsetDateTime dueDate) {
            this.dueDate = Optional.ofNullable(dueDate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "due_date", nulls = Nulls.SKIP)
        public _FinalStage dueDate(Optional<OffsetDateTime> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public InvoiceResponseData build() {
            return new InvoiceResponseData(
                    amountDue,
                    amountPaid,
                    amountRemaining,
                    collectionMethod,
                    companyId,
                    createdAt,
                    currency,
                    customerExternalId,
                    dueDate,
                    environmentId,
                    externalId,
                    id,
                    paymentMethodExternalId,
                    subscriptionExternalId,
                    subtotal,
                    updatedAt,
                    url,
                    additionalProperties);
        }
    }
}
