/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RuleConditionGroupDetailResponseData.Builder.class)
public final class RuleConditionGroupDetailResponseData {
    private final List<RuleConditionDetailResponseData> conditions;

    private final OffsetDateTime createdAt;

    private final String environmentId;

    private final Optional<String> flagId;

    private final String id;

    private final Optional<String> planId;

    private final String ruleId;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private RuleConditionGroupDetailResponseData(
            List<RuleConditionDetailResponseData> conditions,
            OffsetDateTime createdAt,
            String environmentId,
            Optional<String> flagId,
            String id,
            Optional<String> planId,
            String ruleId,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.conditions = conditions;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.flagId = flagId;
        this.id = id;
        this.planId = planId;
        this.ruleId = ruleId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("conditions")
    public List<RuleConditionDetailResponseData> getConditions() {
        return conditions;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("flag_id")
    public Optional<String> getFlagId() {
        return flagId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("plan_id")
    public Optional<String> getPlanId() {
        return planId;
    }

    @JsonProperty("rule_id")
    public String getRuleId() {
        return ruleId;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RuleConditionGroupDetailResponseData
                && equalTo((RuleConditionGroupDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RuleConditionGroupDetailResponseData other) {
        return conditions.equals(other.conditions)
                && createdAt.equals(other.createdAt)
                && environmentId.equals(other.environmentId)
                && flagId.equals(other.flagId)
                && id.equals(other.id)
                && planId.equals(other.planId)
                && ruleId.equals(other.ruleId)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.conditions,
                this.createdAt,
                this.environmentId,
                this.flagId,
                this.id,
                this.planId,
                this.ruleId,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(RuleConditionGroupDetailResponseData other);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        RuleIdStage id(@NotNull String id);
    }

    public interface RuleIdStage {
        UpdatedAtStage ruleId(@NotNull String ruleId);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        RuleConditionGroupDetailResponseData build();

        _FinalStage conditions(List<RuleConditionDetailResponseData> conditions);

        _FinalStage addConditions(RuleConditionDetailResponseData conditions);

        _FinalStage addAllConditions(List<RuleConditionDetailResponseData> conditions);

        _FinalStage flagId(Optional<String> flagId);

        _FinalStage flagId(String flagId);

        _FinalStage planId(Optional<String> planId);

        _FinalStage planId(String planId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage, EnvironmentIdStage, IdStage, RuleIdStage, UpdatedAtStage, _FinalStage {
        private OffsetDateTime createdAt;

        private String environmentId;

        private String id;

        private String ruleId;

        private OffsetDateTime updatedAt;

        private Optional<String> planId = Optional.empty();

        private Optional<String> flagId = Optional.empty();

        private List<RuleConditionDetailResponseData> conditions = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RuleConditionGroupDetailResponseData other) {
            conditions(other.getConditions());
            createdAt(other.getCreatedAt());
            environmentId(other.getEnvironmentId());
            flagId(other.getFlagId());
            id(other.getId());
            planId(other.getPlanId());
            ruleId(other.getRuleId());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public RuleIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("rule_id")
        public UpdatedAtStage ruleId(@NotNull String ruleId) {
            this.ruleId = Objects.requireNonNull(ruleId, "ruleId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_id", nulls = Nulls.SKIP)
        public _FinalStage planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        @java.lang.Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "flag_id", nulls = Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditions(List<RuleConditionDetailResponseData> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditions(RuleConditionDetailResponseData conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public _FinalStage conditions(List<RuleConditionDetailResponseData> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        @java.lang.Override
        public RuleConditionGroupDetailResponseData build() {
            return new RuleConditionGroupDetailResponseData(
                    conditions, createdAt, environmentId, flagId, id, planId, ruleId, updatedAt, additionalProperties);
        }
    }
}
