/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StripeEmbedInfo.Builder.class)
public final class StripeEmbedInfo {
    private final String publishableKey;

    private final Optional<String> setupIntentClientSecret;

    private final Map<String, Object> additionalProperties;

    private StripeEmbedInfo(
            String publishableKey, Optional<String> setupIntentClientSecret, Map<String, Object> additionalProperties) {
        this.publishableKey = publishableKey;
        this.setupIntentClientSecret = setupIntentClientSecret;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("publishable_key")
    public String getPublishableKey() {
        return publishableKey;
    }

    @JsonProperty("setup_intent_client_secret")
    public Optional<String> getSetupIntentClientSecret() {
        return setupIntentClientSecret;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StripeEmbedInfo && equalTo((StripeEmbedInfo) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StripeEmbedInfo other) {
        return publishableKey.equals(other.publishableKey)
                && setupIntentClientSecret.equals(other.setupIntentClientSecret);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.publishableKey, this.setupIntentClientSecret);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PublishableKeyStage builder() {
        return new Builder();
    }

    public interface PublishableKeyStage {
        _FinalStage publishableKey(@NotNull String publishableKey);

        Builder from(StripeEmbedInfo other);
    }

    public interface _FinalStage {
        StripeEmbedInfo build();

        _FinalStage setupIntentClientSecret(Optional<String> setupIntentClientSecret);

        _FinalStage setupIntentClientSecret(String setupIntentClientSecret);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PublishableKeyStage, _FinalStage {
        private String publishableKey;

        private Optional<String> setupIntentClientSecret = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(StripeEmbedInfo other) {
            publishableKey(other.getPublishableKey());
            setupIntentClientSecret(other.getSetupIntentClientSecret());
            return this;
        }

        @java.lang.Override
        @JsonSetter("publishable_key")
        public _FinalStage publishableKey(@NotNull String publishableKey) {
            this.publishableKey = Objects.requireNonNull(publishableKey, "publishableKey must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage setupIntentClientSecret(String setupIntentClientSecret) {
            this.setupIntentClientSecret = Optional.ofNullable(setupIntentClientSecret);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "setup_intent_client_secret", nulls = Nulls.SKIP)
        public _FinalStage setupIntentClientSecret(Optional<String> setupIntentClientSecret) {
            this.setupIntentClientSecret = setupIntentClientSecret;
            return this;
        }

        @java.lang.Override
        public StripeEmbedInfo build() {
            return new StripeEmbedInfo(publishableKey, setupIntentClientSecret, additionalProperties);
        }
    }
}
