/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateRuleRequestBody.Builder.class)
public final class UpdateRuleRequestBody {
    private final List<CreateOrUpdateConditionGroupRequestBody> conditionGroups;

    private final List<CreateOrUpdateConditionRequestBody> conditions;

    private final String name;

    private final int priority;

    private final boolean value;

    private final Map<String, Object> additionalProperties;

    private UpdateRuleRequestBody(
            List<CreateOrUpdateConditionGroupRequestBody> conditionGroups,
            List<CreateOrUpdateConditionRequestBody> conditions,
            String name,
            int priority,
            boolean value,
            Map<String, Object> additionalProperties) {
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.name = name;
        this.priority = priority;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("condition_groups")
    public List<CreateOrUpdateConditionGroupRequestBody> getConditionGroups() {
        return conditionGroups;
    }

    @JsonProperty("conditions")
    public List<CreateOrUpdateConditionRequestBody> getConditions() {
        return conditions;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("priority")
    public int getPriority() {
        return priority;
    }

    @JsonProperty("value")
    public boolean getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateRuleRequestBody && equalTo((UpdateRuleRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateRuleRequestBody other) {
        return conditionGroups.equals(other.conditionGroups)
                && conditions.equals(other.conditions)
                && name.equals(other.name)
                && priority == other.priority
                && value == other.value;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conditionGroups, this.conditions, this.name, this.priority, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        PriorityStage name(@NotNull String name);

        Builder from(UpdateRuleRequestBody other);
    }

    public interface PriorityStage {
        ValueStage priority(int priority);
    }

    public interface ValueStage {
        _FinalStage value(boolean value);
    }

    public interface _FinalStage {
        UpdateRuleRequestBody build();

        _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups);

        _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups);

        _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups);

        _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> conditions);

        _FinalStage addConditions(CreateOrUpdateConditionRequestBody conditions);

        _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, PriorityStage, ValueStage, _FinalStage {
        private String name;

        private int priority;

        private boolean value;

        private List<CreateOrUpdateConditionRequestBody> conditions = new ArrayList<>();

        private List<CreateOrUpdateConditionGroupRequestBody> conditionGroups = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateRuleRequestBody other) {
            conditionGroups(other.getConditionGroups());
            conditions(other.getConditions());
            name(other.getName());
            priority(other.getPriority());
            value(other.getValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("priority")
        public ValueStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditions(CreateOrUpdateConditionRequestBody conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "condition_groups", nulls = Nulls.SKIP)
        public _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.clear();
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @java.lang.Override
        public UpdateRuleRequestBody build() {
            return new UpdateRuleRequestBody(conditionGroups, conditions, name, priority, value, additionalProperties);
        }
    }
}
