/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.core;

import com.schematic.api.core.InputStreamRequestBody;
import java.io.InputStream;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.Nullable;

public class FileStream {
    private final InputStream inputStream;
    private final String fileName;
    private final MediaType contentType;

    public FileStream(InputStream inputStream, @Nullable String fileName, @Nullable MediaType contentType) {
        this.inputStream = Objects.requireNonNull(inputStream, "Input stream cannot be null");
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public FileStream(InputStream inputStream) {
        this(inputStream, null, null);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public MediaType getContentType() {
        return this.contentType;
    }

    public RequestBody toRequestBody() {
        return new InputStreamRequestBody(this.contentType, this.inputStream);
    }
}

